'Edith Copyright 2006 James J Keene

'Edith is a simple text editor

'Usage:
'edith <optional pathname> 

$APPTYPE CONSOLE: $TYPECHECK ON

'uncomment the following line to compile for Linux:
'$DEFINE LINUX

$include "justify.inc"

declare sub ShowMain
declare sub ShowMsg

$include "hlistbox.inc"

$IFNDEF LINUX
app.title="Edith 1.1 Copyright James J Keene PhD"
app.icon = "HotBasic.ico"
$ELSE
setconsolemode 0  '.event mode
$ENDIF

defstr c$,d$,f$,m$,t$
defint i,j,k,n,x,key,nux,txtlen,mod
defint fline=25

dim help as hLISTBOX
help.Left=10: help.Top=7
help.Width=36: help.Height=8
help.Title="Edith 1.1 Help"
help.TitleBkgColor=6: help.BkgColor=5
help.Center=true
help.additems null,"Episode I:",_
 "Edith writes best-seller in kitchen",_
 null,"Copyright 2006-2007 James J Keene",_
 null,"doctorelectron@cwdom.dm"
help.Lines=7

dim ep as hLISTBOX
ep.Top=1: ep.Width=80: ep.Height=23
ep.TitleBkgColor = 13
ep.CurBgkColor = 11
ep.Indent=zero: ep.Focus=True

this=ep

f$=command$(1)
IF f$.length THEN
  Load_File:
  gosub Working
  d$.loadfromfile f$
  ep.clear: ep.Lines=zero: ep.View=one
  nux=zero
  if instr(d$,tab) then d$=replacesubstr$(d$,tab,"  ")
  if not instr(d$,crlf) then d$=replacesubstr$(d$,chr$(10),crlf): inc(nux)
  txtlen=d$.len: mod=zero
  ep.AddList d$
  ep.Lines=d$.itemcount
  if not d$.length then goto New_File
  d$.clear: x=1
else
  goto New_File
end if

ShowMain: goto Key_Done

GetKeyCmd:
i=Console.Event
IF i<>one then goto Key_Done1

IF Console.KeyDown THEN
key=console.KeyCode

SELECT CASE key

CASE 27,3,&H79
setconsolemode 7
color 7,0
cls: App.Terminate   'exit with ESC, ctrl-C or F10

case 8  'BACK
if x>one then dec(x): goto Del_Char
goto Key_Done1

CASE 13  'enter
c$=crlf: goto insert

CASE 38,104  'up
gosub Get_This
if i>one then
  dec(i): goto LB_repaint
else
  if i=one and j>zero then
    dec(j)
    LB_repaint:
    this.Cursor=i: this.TopItem=j
    if ep.Focus then
      gosub ep_show
      k=this.TopItem+this.Cursor
      t$=ep.item(k-one)
      if x>t$.length then x=t$.length+one
      k=100*k/this.Lines
      t$=str$(k)+"% ":
      locate 1,75: color zero,7
      print JustRight(t$,6);
      goto Key_Done
    end if
  end if
end if
goto Key_Done

CASE 40,98  'down
gosub Get_This
arrow_down:
if i+j<this.Lines then
  if i<this.Height then
    inc(i): goto LB_repaint
  else
    inc(j): goto LB_repaint
  end if
end if
goto Key_Done1

CASE 37,100  'left
IF x>one then dec(x)
goto Key_Done

CASE 39,102  'right
if x<80 then inc(x)
goto Key_Done

CASE &H21  'pageup
gosub Get_This
n=j+i-this.Height
if n<zero then n=zero
j=n: i=1
Goto LB_repaint

CASE &H22  'pagedown
gosub Get_This
n=j+i
k=n+this.Height
if k>this.Lines then k=this.Lines
j=k-this.Height: dec(j)
if j<zero then j=zero
i=k-j
if i>this.Height then dec(i)
if i>this.Lines then i=this.Lines
goto LB_repaint

CASE &H23  'end
gosub Get_This
LB_End:
i=this.Height
if this.Lines<this.Height then i=this.Lines
k=this.Lines-i
LB_Scroll:
if k>=zero then j=k else j=zero
Goto LB_repaint 

CASE &H24  'home
gosub Get_This
i=one: j=zero: x=1: Goto LB_repaint

CASE 9  'tab
if x<73 then inc(x,8)

CASE &H70  'F1  Help
help.Show: c$=get$(one)
ShowMain

'CASE &H71  'F2  Menu
'mp.Focus=true: mp.Show

CASE &H72  'F3  New
New_File:
ep.clear: f$.clear
epEx=crlf
txtlen=epEx.len: mod=zero
x=1: ep.Cursor=1: ep.TopItem=zero: ep.Lines=one
nux=zero  'default crlf file
ShowMain

CASE &H73  'F4  Load
t$="Pathname of file to load? "
gosub Get_Input
if c$.length then f$=c$: goto Load_File

CASE &H74  'F5  Save
IF not f$.length then goto Save_As
Save:
if nux then
  d$=replacesubstr$(epEx,crlf,chr$(10))
  d$.savetofile f$: d$.clear
else
  epEx.savetofile f$
end if
txtlen=epEx.len: mod=zero: gosub ep_show

CASE &H75  'F6  SaveAs
Save_As:
t$="SaveAs Pathname? "
gosub Get_Input
if c$.length then f$=c$: goto Save

CASE &H76  'F7  Cut Line
if ep.Focus then
  gosub Get_This
  n=i+j-one: m$=ep.item(n)
  ep.delitems n
  dec(ep.Lines): goto LB_repaint 
end if

CASE &H77  'F8 Insert Line
gosub Get_This
n=i+j-one
ep.insertitem n,m$
inc(ep.Lines): goto arrow_down

CASE &H78  'F9 Convert
IF nux then nux=zero else nux=1
gosub Show25

CASE &H2E  'Delete Char
 Del_Char:
 gosub Get_Position
 if epEx[k]=chr$(13) then n=2 else n=1
 epEx=delete$(epEx,k,n)
 ep.Lines=ep.itemcount: gosub ep_show

CASE else
c$=chr$(console.char)
if c$>=space and c$<="~" then
'insert char here
 insert:
 gosub Get_Position: epEx=insert$(epEx,c$,k)
 if c$=crlf then
  ep.Lines=ep.itemcount: x=1: goto arrow_down
 else
  inc(x): goto LB_repaint
 end if
end if

END SELECT
END IF

Key_Done:
locate this.Cursor+one,x
Key_Done1:
Sleep 0.05: Goto GetKeyCmd

END

Get_Input:
gosub Clear24: color 14,zero: print t$; 
input c$
return

Get_Position:
gosub Get_This
t$=field$(epEx,crlf,i+j): k=hbItem  'get cursor position
IF x>t$.length then x=t$.length: inc(x)
inc(k,x)
return

Get_This:
this=ep
i=this.Cursor: j=this.TopItem
return

Clear24:
locate 24,one: color 7,zero: print space$(79);
locate 24,one
return

Show25:
locate fline,2: color zero,3
print "Help    Menu    New     Load    Save    SaveAs  Cut     Paste   Convert Quit  ";
locate fline,66
if nux then print "LF    "; else print "CRLF  ";
color 7,zero
locate fline,one: print "1";
locate fline,8: print " 2";
locate fline,16: print " 3";
locate fline,24: print " 4";
locate fline,32: print " 5";
locate fline,40: print " 6";
locate fline,48: print " 7";
locate fline,56: print " 8";
locate fline,64: print " 9";
locate fline,72: print "10";
return

sub ShowMain
cls
gosub ep_show
gosub Show25
end sub

ep_show:
n=ep.TopItem+ep.Cursor
if epEx.len<>txtlen then inc(mod)
if mod then t$=" *" else t$=space
ep.Title="Edit: "+f$+space+str$(ep.length)+" bytes; line "+str$(n)+t$
ep.Show
return

sub ShowMsg
gosub Clear24: print JustCenter(c$,78)
end sub

Working:
gosub Clear24: print "Working...";
return
