'Direct3D Immediate Mode 7 demo for HotBasic v5.0a and above
'By Don
'March 1st, 2007. - first running program 
'May  13th, 2007. - recompile with HB 5.2b
'
'note: Tested under Win95OSR2 only. Should work under Win98/ME/XP
'      press ESC to quit application.

$apptype GUI
$typecheck ON
$option dim long

$include "d3dim7_supp.inc"

$define SCREEN_WIDTH  320
$define SCREEN_HEIGHT 320
$define WINDOW_WIDTH  320
$define WINDOW_HEIGHT 320
$define BPP           16


' ----------------------------------------------------------------------
' Direct3D Utilities
' ----------------------------------------------------------------------
declare function D3D7_DEG2RAD    (fa1 as single) as single
declare sub D3DClear             (clr as D3DCOLOR)
declare sub D3DSetIdentityMatrix (lpm as long)
declare sub D3DMatrixRotateY     (lpm as long, angle as single)
declare sub D3DSetVertex         (lpv as long, lpv1 as long, lpvn as long, tu as single, tv as single)
declare sub D3DFlipScene


' ----------------------------------------------------------------------
' User's App3D procedures
' ----------------------------------------------------------------------
declare sub App3D_Init
declare sub App3D_Shutdown
declare sub App3D_InitSurface
declare sub App3D_Action


' ----------------------------------------------------------------------
' Global variables
' ----------------------------------------------------------------------
dim g_pd3dDevice as LPDirect3DDevice7, _
    g_pD3D       as LPDirect3D7, _
    g_pClipper   as LPDirectDrawClipper, _
    g_pDDSBack   as LPDirectDrawSurface7, _
    g_pDDS       as LPDirectDrawSurface7, _
    g_pDD        as LPDirectDraw7

dim g_DDScaps     as DDSCAPS2, _
    g_DDSD        as DDSURFACEDESC2, _
    g_Viewport    as D3DVIEWPORT7

defstr g_Vertices = string$(96, chr$(0)) 'D3DVERTEX * 3
defstr szTitle = "D3DIM7 Demo"
defint d3dhardware
defsng ry = 0.05

App.icon = "dxicon.ico"

' ----------------------------------------------------------------------
' Main Program :
' ----------------------------------------------------------------------
create g_hwnd as FORM
  caption     = szTitle
  maximizebox = 0
  minimizebox = 0
  resizeable  = 0
  width       = WINDOW_WIDTH
  height      = WINDOW_HEIGHT
  onkeydown   = App3D_keydown
  show
end create

' Initialize Direct3D
App3D_Init

' User's OnInitialize code
App3D_InitSurface

do
  if wParam = WM_QUIT then g_hwnd.visible = 0
  doevents
  ' User's gameloop code
  App3D_Action
loop until g_hwnd.visible = 0

App3D_Shutdown
end
' ----------------------------------------------------------------------



' ----------------------------------------------------------------------
' App3D_keydown : keyboard events handler
' ----------------------------------------------------------------------
App3D_keydown:
  if wParam = VK_ESCAPE then g_hwnd.close
  return

' ----------------------------------------------------------------------
' App3D_Init : D3D7 form initialization
' ----------------------------------------------------------------------
sub App3D_Init
  d3dhardware = TRUE

  ' Create a DirectDraw Object 1st
  DirectDrawCreateEx(0, @g_pDD, @IID_IDirectDraw7, 0)
  IDirectDraw7_SetCooperativeLevel(g_pDD, g_hwnd, DDSCL_NORMAL)

  ' Create Primary surface
  ZeroMemory(@g_DDSD, sizeof(DDSURFACEDESC2))
  g_DDSD.dwSize         = sizeof(g_DDSD)
  g_DDSD.dwFlags        = DDSD_CAPS
  g_DDSD.ddsCaps_dwCaps = DDSCAPS_PRIMARYSURFACE + DDSCAPS_VIDEOMEMORY
  IDirectDraw7_CreateSurface(g_pDD, @g_DDSD, @g_pDDS, 0)

  ' then create Clipper Object & attach to Primary surface
  DirectDrawCreateClipper(0, @g_pClipper, 0)
  IDirectDrawClipper_SetHWnd(g_pClipper, 0, g_hwnd)
  IDirectDrawSurface7_SetClipper(g_pDDS, g_pClipper)

  ' Create the Back Buffer & attach to Primary surface
  g_DDSD.dwFlags        = DDSD_CAPS + DDSD_WIDTH + DDSD_HEIGHT
  g_DDSD.dwWidth        = SCREEN_WIDTH
  g_DDSD.dwHeight       = SCREEN_HEIGHT
  g_DDSD.ddsCaps_dwCaps = DDSCAPS_OFFSCREENPLAIN + DDSCAPS_3DDEVICE
  IDirectDraw7_CreateSurface(g_pDD, @g_DDSD, @g_pDDSBack, 0)

  ' Query the Direct3D interface to DirectDraw
  IUnknown_QueryInterface(g_pDD, @IID_IDirect3D7, @g_pD3D)

  ' Create the D3D Device
  if g_pd3dDevice = 0 then _
     g_pd3dDevice = IDirect3D7_CreateDevice(g_pD3D, @IID_IDirect3DTnLHalDevice, g_pDDSBack): _
     g_hwnd.text = szTitle + " [D3DTnLHalDevice]"
  
  ' ok, this 1 don't have TnL HAL, we try HAL instead
  if g_pd3dDevice = 0 then _
     g_pd3dDevice = IDirect3D7_CreateDevice(g_pD3D, @IID_IDirect3DHALDevice, g_pDDSBack): _
     g_hwnd.text = szTitle + " [D3DHALDevice]"

  ' Oh no, looks like this PC don't have 3D acceleration
  if g_pd3dDevice = 0 then '_
     d3dhardware = FALSE ': _
     g_pd3dDevice = IDirect3D7_CreateDevice(g_pD3D, @IID_IDirect3DMMXDevice, g_pDDSBack)
     g_hwnd.text = szTitle + " [D3DMMXDevice]"
  end if

  ' Oh...even don't have MMX support HEL ?? we better quit !!!!
  if g_pd3dDevice = 0 then
     ShowMessage("D3DInit Failed")
     g_hwnd.text = szTitle
     App3D_Shutdown
     g_hwnd.close
  end if

  ' Then we set the Viewport here
  g_Viewport.dwX      = 0
  g_Viewport.dwY      = 0
  g_Viewport.dwWidth  = SCREEN_WIDTH
  g_Viewport.dwHeight = SCREEN_HEIGHT

  defstr s$ = str$(g_Viewport.dvMinZ) 'eliminate SNG bug in UDT!
  g_Viewport.dvMinZ   = 0.0
  g_Viewport.dvMaxZ   = 1.0

  IDirect3DDevice7_SetViewport(g_pd3dDevice, @g_Viewport)
end sub

' ----------------------------------------------------------------------
' App3D_InitSurface : custom user's initializations code
' ----------------------------------------------------------------------
sub App3D_InitSurface
  defstr vxx = string$(24, chr$(0)) 'D3DVECTOR
  
  'set background color
  'reversed RGB() to get D3D_RGB effect
  clr = RGB(192, 128, 128)

  D3DClear(clr)

  ' Create a polygon here
  use xvn as D3DVECTOR with @vxx+12
    use vv as D3DVECTOR with @vxx

      xvn.x = 0.0
      xvn.y = xvn.x
      xvn.z = 0.8

      vv.z  = 0.0
      vv.x  = 0.0
      vv.y  = 3.0

      D3DSetVertex(@g_Vertices, @vv, @xvn, 0, 0)

      vv.x =  3.0
      vv.y = -3.0

      D3DSetVertex(@g_Vertices+32, @vv, @xvn, 0, 0)

      vv.x = -3.0
      vv.y = -3.0

      D3DSetVertex(@g_Vertices+64, @vv, @xvn, 0, 0)

    end use xvn
  end use vv

  ' we need a Material for lighting, set to yellow
  defstr vmtrl = string$(68, chr$(0))

  use mtrl as D3DMATERIAL7 with @vmtrl
    mtrl.ambient_r = 1.0
    mtrl.ambient_g = 1.0
    mtrl.ambient_b = 0.0
  
    IDirect3DDevice7_SetMaterial(g_pd3dDevice, @mtrl)
    IDirect3DDevice7_SetRenderState(g_pd3dDevice, D3DRENDERSTATE_AMBIENT, &Hffffffff)

    ' Finally, setup World, View & Projection
    defstr vmat = string$(64, chr$(0)) 'D3DMATRIX

    use mat as D3DMATRIX with @vmat
      D3DSetIdentityMatrix(@mat)
      IDirect3DDevice7_SetTransform(g_pd3dDevice, D3DTRANSFORMSTATE_WORLD, @mat)

      D3DSetIdentityMatrix(@mat)
      mat.rc43 = 10.0

      IDirect3DDevice7_SetTransform(g_pd3dDevice, D3DTRANSFORMSTATE_VIEW, @mat)

      D3DSetIdentityMatrix(@mat)
      mat.rc11 =  2.0
      mat.rc22 =  2.0
      mat.rc34 =  1.0
      mat.rc43 = -2.0
      mat.rc44 =  0.0

      IDirect3DDevice7_SetTransform(g_pd3dDevice, D3DTRANSFORMSTATE_PROJECTION, @mat)
    end use mat
  end use mtrl
end sub

' ----------------------------------------------------------------------
' App3D_Action : custom user's activations code
' ----------------------------------------------------------------------
sub App3D_Action
  ' Matrix used for polygon rotation
  defstr vmat = string$(64, chr$(0)) 'D3DMATRIX size

  use mat as D3DMATRIX with @vmat

    D3DSetIdentityMatrix(@mat)
    D3DClear(clr)

    IDirect3DDevice7_BeginScene(g_pd3dDevice)

      ' increase the rotation at Y-Axis, in degree
      ry = 0.3 + ry
      if ry > 360.0 then ry = 0.0

      D3DMatrixRotateY(@mat, ry)
      IDirect3DDevice7_SetTransform(g_pd3dDevice, D3DTRANSFORMSTATE_WORLD, @mat)
      ' we turn off the cull mode, so we can see the backface
      IDirect3DDevice7_SetRenderState(g_pd3dDevice, D3DRENDERSTATE_CULLMODE, D3DCULL_NONE )
      ' Draw the polygon
      IDirect3DDevice7_DrawPrimitive(g_pd3dDevice, D3DPT_TRIANGLELIST, D3DFVF_VERTEX, @g_Vertices, 3, 0)

    IDirect3DDevice7_EndScene(g_pd3dDevice)

    D3DFlipScene
  end use mat
end sub

' ----------------------------------------------------------------------
' App3D_Shutdown : Shutdown D3D Core Interfaces
' ----------------------------------------------------------------------
sub App3D_Shutdown
  if g_pd3dDevice <> 0 then IUnknown_Release(g_pd3dDevice)
  if g_pD3D       <> 0 then IUnknown_Release(g_pD3D)
  if g_pDDSBack   <> 0 then IUnknown_Release(g_pDDSBack)
  if g_pClipper   <> 0 then IUnknown_Release(g_pClipper)
  if g_pDDS       <> 0 then IUnknown_Release(g_pDDS)
  if g_pDD        <> 0 then IUnknown_Release(g_pDD)
end sub





' Supporting D3D utilities begin here


' ----------------------------------------------------------------------
' D3D7_DEG2RAD : Deg2Rad converter
' ----------------------------------------------------------------------
function D3D7_DEG2RAD (fa1 as single) as single
  result = fa1 * 0.01745329251994329 '57692
end function

' ----------------------------------------------------------------------
' D3DClear : Clear a surface area with given color
' ----------------------------------------------------------------------
sub D3DClear (clr as D3DCOLOR)
  IDirect3DDevice7_Clear(g_pd3dDevice, 0, 0, D3DCLEAR_TARGET, clr, 1.0, 0)
  if iRet then ShowMessage("D3DClear failed!")
end sub

' ----------------------------------------------------------------------
' D3DSetIdentityMatrix : set TransformMatrix 4x4 values
' ----------------------------------------------------------------------
sub D3DSetIdentityMatrix (lpm as long)
  use m as D3DMATRIX with lpm
    m.rc11 = 1.0:  m.rc12 = 0.0:  m.rc13 = 0.0:  m.rc14 = 0.0
    m.rc21 = 0.0:  m.rc22 = 1.0:  m.rc23 = 0.0:  m.rc24 = 0.0
    m.rc31 = 0.0:  m.rc32 = 0.0:  m.rc33 = 1.0:  m.rc34 = 0.0
    m.rc41 = 0.0:  m.rc42 = 0.0:  m.rc43 = 0.0:  m.rc44 = 1.0
  end use m
end sub

' ----------------------------------------------------------------------
' D3DMatrixRotateY : 
' ----------------------------------------------------------------------
sub D3DMatrixRotateY (lpm as long, angle as single)
  defsng c = cos(D3D7_DEG2RAD(angle))
  defsng s = sin(D3D7_DEG2RAD(angle))
  use m as D3DMATRIX with lpm
    m.rc11 = c
    m.rc31 = -s
    m.rc13 = s
    m.rc33 = c
  end use m
end sub

' ----------------------------------------------------------------------
' D3DSetVertex : 
' ----------------------------------------------------------------------
sub D3DSetVertex(lpv as long, lpv1 as long, lpvn as long, tu as single, tv as single)
  use v as D3DVERTEX with lpv
    use v1 as D3DVECTOR with lpv1
      use vn as D3DVECTOR with lpvn
        v.x  = v1.x
        v.y  = v1.y
        v.z  = v1.z
        v.nx = vn.x
        v.ny = vn.y
        v.nz = vn.z
        v.tu = tu
        v.tv = tv
      end use vn
    end use v1
  end use v
end sub

' ----------------------------------------------------------------------
' D3DFlipScene : Windowed Double buffering flip
' ----------------------------------------------------------------------
sub D3DFlipScene
  dim rcSrc  as RECT, _ ' source blit rectangle
      rcDest as RECT    ' destination blit rectangle

  funccall(GetClientRect, g_hwnd, @rcDest)

  ClientToScreen(g_hwnd, @rcDest)
  ClientToScreen(g_hwnd, @rcDest+8)

  SetRect(@rcSrc, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT)

  if IDirectDrawSurface7_IsLost(g_pDDS) = DDERR_SURFACELOST _
     then IDirectDrawSurface7_Restore(g_pDDS)

  if IDirectDrawSurface7_Blt(g_pDDS, @rcDest, g_pDDSBack, @rcSrc, DDBLT_WAIT, 0) then
     ' If cannot Blt, just quit the game
     ShowMessage("D3DFlipWin failed!")
  end if
end sub
