'Direct3D Immediate Mode 7 demo includes for HotBasic v5.0a and above
'By Don
'March 1st, 2007. - first running program
'May  13th, 2007. - recompile with HB 5.2b
'
'note: Tested under Win95OSR2 only. Should work under Win98/ME/XP
'      press ESC to quit application


' ----------------------------------------------------------------------
' DirectDraw types
' ----------------------------------------------------------------------
'DDSCAPS2 = 16
Type DDSCAPS2
  dwCaps  as dword
  dwCaps2 as dword
  dwCaps3 as dword
  dwCaps4 as dword
End Type

'DDCOLORKEY = 8
type DDCOLORKEY
    dwColorSpaceLowValue  as dword
    dwColorSpaceHighValue as dword
end type

'DDSURFACEDESC2 = 124
type DDSURFACEDESC2
  dwSize   as dword
  dwFlags  as dword
  dwHeight as dword
  dwWidth  as dword
    lPitch       as dword
  '  dwLinearSize as dword
  dwBackBufferCount as dword
  '  dwMipMapCount as dword
    dwRefreshRate as dword
  dwAlphaBitDepth as dword
  dwReserved      as dword
  lpSurface       as dword
  '  ddckCKDestOverlay as DDCOLORKEY
      ddckCKDestOverlay_dwColorSpaceLowValue  as dword
      ddckCKDestOverlay_dwColorSpaceHighValue as dword
  '  dwEmptyFaceColor as dword
  'ddckCKDestBlt as DDCOLORKEY
    ddckCKDestBlt_dwColorSpaceLowValue  as dword
    ddckCKDestBlt_dwColorSpaceHighValue as dword
  'ddckCKSrcOverlay as DDCOLORKEY
    ddckCKSrcOverlay_dwColorSpaceLowValue  as dword
    ddckCKSrcOverlay_dwColorSpaceHighValue as dword
  'ddckCKSrcBlt as DDCOLORKEY
    ddckCKSrcBlt_dwColorSpaceLowValue  as dword
    ddckCKSrcBlt_dwColorSpaceHighValue as dword
  '  ddpfPixelFormat as DDPIXELFORMAT
      ddpfPixelFormat_dwSize   as dword
      ddpfPixelFormat_dwFlags  as dword
      ddpfPixelFormat_dwFourCC as dword
      ddpfPixelFormat_u1       as dword
      ddpfPixelFormat_u2       as dword
      ddpfPixelFormat_u3       as dword
      ddpfPixelFormat_u4       as dword
      ddpfPixelFormat_u5       as dword
  '  dwFVF as dword
  'ddsCaps as DDSCAPS2
    ddsCaps_dwCaps  as dword
    ddsCaps_dwCaps2 as dword
    ddsCaps_dwCaps3 as dword
    ddsCaps_dwCaps4 as dword
  dwTextureStage as dword
end type



' ----------------------------------------------------------------------
' Direct3D types
' ----------------------------------------------------------------------
'D3DMATRIX = 64
Type D3DMATRIX
  rc11 As Single
  rc12 As Single
  rc13 As Single
  rc14 As Single

  rc21 As Single
  rc22 As Single
  rc23 As Single
  rc24 As Single

  rc31 As Single
  rc32 As Single
  rc33 As Single
  rc34 As Single

  rc41 As Single
  rc42 As Single
  rc43 As Single
  rc44 As Single
End Type

'D3DRECT = 16
Type D3DRECT 
  x1 as dword
  x2 as dword
  y1 as dword
  y2 as dword
End Type

'D3DVECTOR = 12
Type D3DVECTOR
  x As Single
  y As Single
  z As Single
End Type

'D3DVERTEX = 32
Type D3DVERTEX
  x  As Single
  y  As Single
  z  As Single
  nx As Single
  ny As Single
  nz As Single
  tu As Single
  tv As Single
End Type


'D3DCOLORVALUE = 16
type D3DCOLORVALUE
  r  as single
  ' dvR as single
  g  as single
  ' dvG as single
  b  as single 
  ' dvB
  a  as single
end type

'D3DMATERIAL7 = 68
Type D3DMATERIAL7
  ' diffuse As D3DCOLORVALUE
     diffuse_r as single
     diffuse_g as single
     diffuse_b as single 
     diffuse_a as single
  ' ambient As D3DCOLORVALUE
     ambient_r as single
     ambient_g as single
     ambient_b as single 
     ambient_a as single
  ' specular As D3DCOLORVALUE
     specular_r as single
     specular_g as single
     specular_b as single 
     specular_a as single
  ' emissive As D3DCOLORVALUE
     emissive_r as single
     emissive_g as single
     emissive_b as single 
     emissive_a as single
  power As Single
End Type

'D3DVIEWPORT7 = 24
Type D3DVIEWPORT7
    dwX      as dword
    dwY      as dword
    dwWidth  as dword
    dwHeight as dword
    dvMinZ   As Single
    dvMaxZ   As Single
End Type






' ----------------------------------------------------------------------
' Constants
' ----------------------------------------------------------------------
$define D3DCOLOR long
$define DDBLT_WAIT &H01000000
$define DDERR_SURFACELOST &H088760450 'MAKE_DDHRESULT + &H450
$define DDSCAPS_OFFSCREENPLAIN 64 '&H00000040
$define DDSCAPS_3DDEVICE &H00002000
$define DDSCAPS_PRIMARYSURFACE 512  '&H00000200
$define DDSCAPS_VIDEOMEMORY &H00004000
$define DDSD_CAPS 1
$define DDSD_HEIGHT 2
$define DDSD_WIDTH 4
$define DDSCL_NORMAL 8 '&H00000081
$define D3DCULL_NONE 1
'$define D3DFVF_XYZ &H002
'$define D3DFVF_NORMAL &H010
'$define D3DFVF_TEX1 &H100
$define D3DFVF_VERTEX &H112 'D3DFVF_XYZ OR D3DFVF_NORMAL OR D3DFVF_TEX1
$define D3DCLEAR_TARGET 1
$define D3DPT_TRIANGLELIST 4
$define D3DRENDERSTATE_AMBIENT 139
$define D3DRENDERSTATE_CULLMODE 22
$define D3DTRANSFORMSTATE_WORLD 1
$define D3DTRANSFORMSTATE_VIEW 2
$define D3DTRANSFORMSTATE_PROJECTION 3

const D3D_PI = 3.14159265358979323846

$define CS_HREDRAW 2
$define CS_VREDRAW 1
$define CW_USEDEFAULT &H80000000
$define IDC_ARROW 32512
$define PM_REMOVE 1
$define SC_MOVE 61456
$define SC_SIZE 61440
$define SC_MAXIMIZE 61488
$define SC_KEYMENU 61696
$define SC_MONITORPOWER 61808
$define SIZE_MAXHIDE 4
$define SIZE_MINIMIZED 1
$define VK_ESCAPE 27
$define VK_F1 112
$define WM_ACTIVATE 6
$define WM_DESTROY 2       '16
$define WM_KEYDOWN 256
$define WM_PAINT 15
$define WM_QUIT 18
$define WM_SETCURSOR 32
$define WM_SIZE 5
$define WM_SYSCOMMAND &H0112  '274
$define WS_OVERLAPPED 0
$define WS_SYSMENU &H80000

$define LPDirect3DDevice7 Long
$define LPDirect3D7 Long
$define LPDirectDrawClipper Long
$define LPDirectDrawSurface7 Long
$define LPDirectDraw7 Long




' ----------------------------------------------------------------------
' DLL imports
' ----------------------------------------------------------------------
declare sub ClientToScreen          lib "user32"  (iArg1 as long, iArg2 as long)
declare sub DirectDrawCreateEx      lib "ddraw"   (iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long)
declare sub DirectDrawCreateClipper lib "ddraw"   (iArg1 as long, iArg2 as long, iArg3 as long)
declare sub SetRect                 lib "user32"  (iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long, iArg5 as long)
declare sub ZeroMemory              lib "kernel32" Alias "RtlZeroMemory" (iArg1 as long, iArg2 as long)

' ----------------------------------------------------------------------
' COM procedure declarations
' ----------------------------------------------------------------------
declare sub DEFINE_GUID             (pGUID as long, any$ as string)

declare sub IUnknown_QueryInterface (ppvObj as long, iArg1 as long, iArg2 as long)
declare sub IUnknown_Release        (ppvObj as long)

' ----------------------------------------------------------------------
' DirectDraw procedure declarations
' ----------------------------------------------------------------------
declare sub IDirectDraw7_CreateSurface       (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long)
declare sub IDirectDraw7_SetCooperativeLevel (ppvObj as long, iArg1 as long, iArg2 as long)

declare sub IDirectDrawClipper_SetHWnd       (ppvObj as long, iArg1 as long, iArg2 as long)

declare function IDirectDrawSurface7_Blt     (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long, iArg5 as long) as long
declare function IDirectDrawSurface7_IsLost  (ppvObj as long) as long
declare sub IDirectDrawSurface7_Restore      (ppvObj as long)
declare sub IDirectDrawSurface7_SetClipper   (ppvObj as long, iArg1 as long)

' ----------------------------------------------------------------------
' Direct3D procedure declarations
' ----------------------------------------------------------------------
declare function IDirect3D7_CreateDevice    (ppvObj as long, iArg1 as long, iArg2 as long) as long

declare sub IDirect3DDevice7_BeginScene     (ppvObj as long)
declare sub IDirect3DDevice7_EndScene       (ppvObj as long)
declare sub IDirect3DDevice7_Clear          (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long, fArg5 as single, iArg6 as long)
declare sub IDirect3DDevice7_SetTransform   (ppvObj as long, iArg1 as long, iArg2 as long)
declare sub IDirect3DDevice7_SetViewport    (ppvObj as long, iArg1 as long)
declare sub IDirect3DDevice7_SetMaterial    (ppvObj as long, iArg1 as long)
declare sub IDirect3DDevice7_SetRenderState (ppvObj as long, iArg1 as long, iArg2 as long)
declare sub IDirect3DDevice7_DrawPrimitive  (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long, iArg5 as long)



' ----------------------------------------------------------------------
' COM GUID variables
' ----------------------------------------------------------------------
defint ppMethod, iRet
defstr IID_IDirectDraw7 = string$(16, chr$(0))
defstr IID_IDirect3D7 = string$(16, chr$(0))
defstr IID_IDirect3DTnLHalDevice = string$(16, chr$(0))
defstr IID_IDirect3DHALDevice = string$(16, chr$(0))
defstr IID_IDirect3DMMXDevice = string$(16, chr$(0))

DEFINE_GUID(@IID_IDirectDraw7,          "{15E65EC0-3B9C-11D2-B92F-00609797EA5B}")
DEFINE_GUID(@IID_IDirect3D7,            "{F5049E77-4861-11d2-A407-00A0C90629A8}")
DEFINE_GUID(@IID_IDirect3DTnLHalDevice, "{F5049E78-4861-11d2-a407-00a0c90629A8}")
DEFINE_GUID(@IID_IDirect3DHALDevice,    "{84E63DE0-46AA-11CF-816F-0000C020156E}")
DEFINE_GUID(@IID_IDirect3DMMXDevice,    "{881949A1-D6F3-11D0-89AB-00A0C9054129}")




' ----------------------------------------------------------------------
' DEFINE_GUID : (pGUID&, any$)
' ----------------------------------------------------------------------
sub DEFINE_GUID (pGUID as long, any$ as string)
  defint xN
  defstr xget$
  if len(any$) <> 38 then exit sub
  xget$ = mid$(any$,2,8)
  gosub xConv:  memcpy(pGUID, @xN, 4)
  xget$ = mid$(any$,16,4) + mid$(any$,11,4)
  gosub xConv:  memcpy(pGUID+4, @xN, 4)
  xget$ = mid$(any$,28,2) + mid$(any$,26,2) + _
          mid$(any$,23,2) + mid$(any$,21,2)
  gosub xConv:  memcpy(pGUID+8, @xN, 4)
  xget$ = mid$(any$,36,2) + mid$(any$,34,2) + _
          mid$(any$,32,2) + mid$(any$,30,2)
  gosub xConv:  memcpy(pGUID+12, @xN, 4)
  gosub xResIID
  xConv:
    xN = hex2dw(xget$)
    return
  xResIID:
end sub


' ----------------------------------------------------------------------
' IUnknown COM Interface
' ----------------------------------------------------------------------
sub IUnknown_QueryInterface (ppvObj as long, iArg1 as long, iArg2 as long)
  ppMethod = byref(byref(ppvObj) + 0)
  funccall(ppMethod, ppvObj, iArg1, iArg2)
  iRet = retfunc
end sub

sub IUnknown_Release (ppvObj as long)
  ppMethod = byref(byref(ppvObj) + 8)
  funccall(ppMethod, ppvObj)
  iRet = retfunc
end sub

' ----------------------------------------------------------------------
' IDirectDraw7 COM Interface
' ----------------------------------------------------------------------
sub IDirectDraw7_CreateSurface (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long)
  ppMethod = byref(byref(ppvObj) + 24)
  funccall(ppMethod, ppvObj, iArg1, iArg2, iArg3)
  iRet = retfunc
end sub

sub IDirectDraw7_SetCooperativeLevel (ppvObj as long, iArg1 as long, iArg2 as long)
  ppMethod = byref(byref(ppvObj) + 80)
  funccall(ppMethod, ppvObj, iArg1, iArg2)
  iRet = retfunc
end sub

' ----------------------------------------------------------------------
' IDirectDrawClipper COM Interface
' ----------------------------------------------------------------------
sub IDirectDrawClipper_SetHWnd (ppvObj as long, iArg1 as long, iArg2 as long)
  ppMethod = byref(byref(ppvObj) + 32)
  funccall(ppMethod, ppvObj, iArg1, iArg2)
  iRet = retfunc
end sub

' ----------------------------------------------------------------------
' IDirectDrawSurface7 COM Interface
' ----------------------------------------------------------------------
function IDirectDrawSurface7_Blt (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long, iArg5 as long) as long
  ppMethod = byref(byref(ppvObj) + 20)
  funccall(ppMethod, ppvObj, iArg1, iArg2, iArg3, iArg4, iArg5)
  result = retfunc
end function

function IDirectDrawSurface7_IsLost (ppvObj as long) as long
  ppMethod = byref(byref(ppvObj) + 96)
  funccall(ppMethod, ppvObj)
  result = retfunc
end function

sub IDirectDrawSurface7_Restore (ppvObj as long)
  ppMethod = byref(byref(ppvObj) + 108)
  funccall(ppMethod, ppvObj)
  iRet = retfunc
end sub

sub IDirectDrawSurface7_SetClipper (ppvObj as long, iArg1 as long)
  ppMethod = byref(byref(ppvObj) + 112)
  funccall(ppMethod, ppvObj, iArg1)
  iRet = retfunc
end sub

' ----------------------------------------------------------------------
' IDirect3D7 COM Interface
' ----------------------------------------------------------------------
function IDirect3D7_CreateDevice (ppvObj as long, iArg1 as long, iArg2 as long) as long
  defint pOut
  if pOut then IUnknown_Release(pOut)
  ppMethod = byref(byref(ppvObj) + 16)
  funccall(ppMethod, ppvObj, iArg1, iArg2, @pOut)
  iRet = retfunc
  result = pOut
end function

' ----------------------------------------------------------------------
' IDirect3DDevice7 COM Interface
' ----------------------------------------------------------------------
sub IDirect3DDevice7_BeginScene (ppvObj as long)
  ppMethod = byref(byref(ppvObj) + 20)
  funccall(ppMethod, ppvObj)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) + ":IDirect3DDevice7_BeginScene has failed")
end sub

sub IDirect3DDevice7_EndScene (ppvObj as long)
  ppMethod = byref(byref(ppvObj) + 24)
  funccall(ppMethod, ppvObj)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) + ":IDirect3DDevice7_EndScene has failed")
end sub

sub IDirect3DDevice7_Clear (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long, fArg5 as single, iArg6 as long)
  ppMethod = byref(byref(ppvObj) + 40)
  funccall(ppMethod, ppvObj, iArg1, iArg2, iArg3, iArg4, fArg5, iArg6)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) + ": IDirect3DDevice7_Clear has failed")
end sub

sub IDirect3DDevice7_SetTransform (ppvObj as long, iArg1 as long, iArg2 as long)
  ppMethod = byref(byref(ppvObj) + 44)
  funccall(ppMethod, ppvObj, iArg1, iArg2)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) +"IDirect3DDevice7_SetTransform has failed")
end sub

sub IDirect3DDevice7_SetViewport (ppvObj as long, iArg1 as long)
  ppMethod = byref(byref(ppvObj) + 52)
  funccall(ppMethod, ppvObj, iArg1)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) +"IDirect3DDevice7_SetViewport has failed")
end sub

sub IDirect3DDevice7_SetMaterial (ppvObj as long, iArg1 as long)
  ppMethod = byref(byref(ppvObj) + 64)
  funccall(ppMethod, ppvObj, iArg1)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) +"IDirect3DDevice7_SetMaterial has failed")
end sub

sub IDirect3DDevice7_SetRenderState (ppvObj as long, iArg1 as long, iArg2 as long)
  ppMethod = byref(byref(ppvObj) + 80)
  funccall(ppMethod, ppvObj, iArg1, iArg2)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) +"IDirect3DDevice7_SetRenderState has failed")
end sub

sub IDirect3DDevice7_DrawPrimitive (ppvObj as long, iArg1 as long, iArg2 as long, iArg3 as long, iArg4 as long, iArg5 as long)
  ppMethod = byref(byref(ppvObj) + 100)
  funccall(ppMethod, ppvObj, iArg1, iArg2, iArg3, iArg4, iArg5)
  iRet = retfunc
  if iRet then showmessage (hex$(iRet) +"IDirect3DDevice7_DrawPrimitive has failed")
end sub

