$APPTYPE CONSOLE:$TYPECHECK ON
'$RESOURCE Hot_icon AS "hotbasic.ico"
$SYMBOLTABLE ON
DIM i As LONG, j As LONG, k As LONG, n As LONG, k$ As STRING
DEFreal10 x,y,z

SETCONSOLETITLE "HotBasic(tm) Operator Precedence and Numeric Expression Test 1.1"

COLOR 11: PRINT "Operator Precedence": COLOR 7
i=2+3*7
PRINT "2+3*7 = ";STR$(i);
IF i = 23 THEN PRINT " correct" ELSE PRINT " WRONG!"
j=2*3+7
PRINT "2*3+7 = ";STR$(j);
IF j = 13 THEN PRINT " correct" ELSE PRINT " WRONG!"
j=2 OR 3*7
PRINT "2 OR 3*7 = ";STR$(j);
IF j = 23 THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11: PRINT "Operator Precedence Over-ride": COLOR 7
i=(2+3)^2
PRINT "(2+3)^2 = ";STR$(i);
IF i = 25 THEN PRINT " correct" ELSE PRINT " WRONG!"
i=2^(1+2)
PRINT "2^(1+2) = ";STR$(i);
IF i = 8 THEN PRINT " correct" ELSE PRINT " WRONG!"
j=5*(3+1)
PRINT "5*(3+1) = ";STR$(j);
IF j = 20 THEN PRINT " correct" ELSE PRINT " WRONG!"

'=====code below requires v2.5g
x=0.5
COLOR 11: PRINT "More complex; x = 0.5": COLOR 7

z=atan(x/sqr(1-x^2))
PRINT "asin(x) = atan(x/sqr(1-x^2)) = ";STR$(z);
IF z = asin(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

z=atan(sqr(1-x^2)/x)
PRINT "acos(x) = atan(sqr(1-x^2)/x) = ";STR$(z);
IF z = acos(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

z=(exp(x)-exp(-(x)))/2
PRINT "hsin(x) = (exp(x)-exp(-(x)))/2 = ";STR$(z);
IF z = hsin(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

z=(exp(x)+exp(-(x)))/2
PRINT "hcos(x) = (exp(x)+exp(-(x)))/2 = ";STR$(z);
IF z = hcos(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

'this monster expression is used here for testing:
z=(exp(x)-exp(-(x)))/(exp(x)+exp(-(x)))

'obviously, it is much more efficient to do this:
'y=exp(x): z=exp(-(x))   'note "-(x)" = "neg(x)"
'z=(y-z)/(y+z)

PRINT "htan(x) = (exp(x)-exp(-(x)))/(exp(x)+exp(-(x))) = ";STR$(z);
IF z = htan(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11: PRINT "Unnecessary () in conditional expression": COLOR 7
if (1=3) or (2=2) then print "correct"
if ("a"="b") or ("c"="c") then print "correct"

COLOR 11: PRINT "Precedence over-ride in function argument": COLOR 7
i = int(100.00*(2.75 - 2.00))
PRINT "int(100.00*(2.75 - 2.00)) = ";STR$(i);
IF i = 75 THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11: PRINT "Leading precedence over-ride in function argument": COLOR 7
i = int((2.75 - 2.00) * 100.00)
PRINT "int((2.75 - 2.00) * 100.00) = ";STR$(i);
IF i = 75 THEN PRINT " correct" ELSE PRINT " WRONG!"
i = FIX(((2000.0-1000.0)*(8.0/100) + (200.0/100))*100)
PRINT "FIX(((2000.0-1000.0)*(8.0/100) + (200.0/100))*100) = ";STR$(i);
IF i = 8200 THEN PRINT " correct" ELSE PRINT " WRONG!"
pause
COLOR 11: PRINT "Numeric argument in string function followed by +": COLOR 7
k$="##"
k$=k$+CHR$(65)+k$
PRINT "k$+CHR$(65)+k$ = "; k$;
IF k$="##A##" THEN PRINT " correct" ELSE PRINT " WRONG!"
pause
END

