$APPTYPE CONSOLE: $TYPECHECK ON
app.title = "HotBasic Linux SOCKET to me"

dim peer as socket, r as long

print
print ".AddrToStr(&H100007f)  = "; peer.AddrToStr(&H100007f)
defint a = peer.StrToAddr("127.0.0.1")
print ".StrToAddr("; quote; "127.0.0.1"; quote; ") = "; hex$(a)
print ".GetHostName = "; peer.GetHostName
print ".GetHostIP   = "; peer.GetHostIP
print ".Family      = "; peer.Family
print ".Type        = "; peer.Type
print ".Protocol    = "; peer.Protocol

color 11
print "Use .Socket to create and .Close a socket handle"
color 7
defint hS = peer.Socket(2,1,0)  'create socket
print ".Socket(2,1,0) handle = "; str$(hS)
print ".Handle   = "; peer.Handle
r = peer.close(hS)

color 11
print "Let's make a Server and Client in same program!"
print "...sort of like a peer-to-peer application."
print "Use .Open to create a TCP listening socket"
color 7
hS = peer.open(8081)  'listen on port 8081
print ".Open socket = "; str$(hS)

color 11
print "Use .S to create a TCP Client socket"
color 7
defint hC = peer.S  'create socket
print ".S handle = "; str$(hC)
print ".Handle   = "; peer.Handle
color 11
print "Use .Connect to localhost port 8081 Server"
color 7
r = peer.Connect(hC,"127.0.0.1",8081)
print ".Connect result = "; str$(r)
sleep 0.5

color 11
print "Use .Accept to complete service Client .Connect"
color 7
if peer.ConnectionReady(hS) then
  defint hC1 = peer.Accept(hS)
  print ".Accept client handle = "; str$(hC1)
  print ".GetPeerName Client IP= "; peer.GetPeerName(hC1)
else
  print "Client .Connect not detected": goto TheEnd
end if
pause
color 11
print "Use .IsConnected to detect writable socket"
color 7
r = peer.IsConnected(hC,0)
print ".IsConnected(hC,0) = "; str$(r)
if r then
'if peer.IsConnected(hC,0) then
  print "Let's go; we're connected to Server"
else
  print "Writeable Client connection not detected": Goto TheEnd
end if
color 11
print "Use .Send to make request to Server"
color 7
defstr req$ = "Is HotBasic Linux SOCKET cool?"
r = peer.Send(hC,req$,req$.Length)
sleep 0.9

color 11
print "Use .Recv to get request from Client"
color 7
if peer.IsServerReady(hC1) then
  defstr recv$ = STRING$(1024,chr$(0))
  r = peer.Recv(hC1,recv$,1024)
else
  print "Received Client data not detected": goto TheEnd
end if
if r > 0 then
  print ".Recv by Server got this: ";
  color 10: print left$(recv$,r): color 7
end if

color 11
print "Use .Send to reply to Client"
color 7
defstr reply$ = "Well, HotBabe says it is"
r = peer.Send(hC1,reply$,reply$.Length)
sleep 0.5

color 11
print "Use .Recv to get reply from Server"
color 7
if peer.IsServerReady(hC) then
  recv$ = STRING$(1024,chr$(0))
  r = peer.Recv(hC,recv$,1024)
else
  print "Received Server data not detected": goto TheEnd
end if
if r > 0 then
  print ".Recv by Client got this: ";
  color 10: print left$(recv$,r): color 7
end if

TheEnd:
color 11
print "Use .Close by Server of Client and Listening Sockets"
color 7
r = peer.close(hC1): r = peer.close(hS)
color 11
print "Use .Close by Client of connection to Server"
color 7
r = peer.close(hC)
PAUSE
END

