'from GenericCOM.inc by Emmazle edited by James J Keene

'- part 1: declarations of variables and subs
$ifndef ComHelperGenerics
$define ComHelperGenerics
$typecheck on
$equalprec on

'TYPE definitions
type INTERFACE 'generic IDispatch interface wrapper
  pointer as integer 'pointer to object's interface
  CreateObject as sub 'create object with given progID or CLSID: myobj.CreateObject("MSCAL.Calendar")
  invoke as sub 'standard ActiveX Invoke wrapper, defined below
  getnum as function 'standard ActiveX Invoke wrapper, defined below
  getstr as function 'standard ActiveX Invoke wrapper, defined below
  QueryInterface as function 'return other interface, defined below
  ConnectEvents as sub 'connect an event interface in order to receive events
  DisconnectEvents as sub 'disconnect object's events. Can be used before re-connecting to a different event interface
  SetEvent as sub  'register a user-defined event handler: myobj.SetEvent(eventcode, codeptr(thesub))
end type

type ACTIVEX extends LISTVIEW 'generic ACTIVEX object
  pointer as integer 'pointer to object's interface
  CreateActiveX as sub 'create object with given progID: myobj.CreateActiveX("MSCAL.Calendar")
  invoke as sub 'standard ActiveX Invoke wrapper, defined below
  getnum as function 'standard ActiveX Invoke wrapper, defined below
  getstr as function 'standard ActiveX Invoke wrapper, defined below
  QueryInterface as function 'return other interface, defined below
  ConnectEvents as sub 'connect an event interface in order to receive events. Nota: activeX objects are automatically connected to their default event interface on creation.
  DisconnectEvents as sub 'disconnect object's events. Can be used before re-connecting to a different event interface
  SetEvent as sub  'register a user-defined event handler: myobj.SetEvent(eventcode, codeptr(thesub))
end type

type GUID
  d1  as integer
  d23 as integer
  d4  as integer
  d5  as integer
end type

type DISPPARAMS
  rgvarg as integer 'pointer to a variant array
  rgdispidnamedargs as integer 'identifier of "named arguments"
  cArgs as integer 'total number of arguments
  cNamedArgs as integer 'number of "named arguments"
end type

'--ENUM object: implements "for each" loops
'usage:
'dim foreach as ENUM, thisobj as INTERFACE
'foreach.Enum(an interface that is a collection of objects)
'  thisobj.pointer=foreach.NextItem
'  if thisobj.pointer then [do something with the object thus retrieved].
'    Note: you MUST test for thisobj.pointer<>0
'foreach.EndEnum
type ENUM
  pointer as integer=0 'pointer to an IEnumVARIANT interface
  loopstart as integer=0 'address of beginning of the "for each" loop
  nextfunction as integer=0 'address of .Next function of IEnumVARIANT
  lastresult as integer=0 'keep last value in memory. loop stops when this value is zero
  Enum as sub
  NextItem as function
  EndEnum as sub
end type

'sub declares
declare sub ComInit
declare function WinErrorMsg(dwError as integer) as string
declare function ANSI(lps as integer) as string
declare sub setindirect(setindirectv as variant,setindirecti as integer)
declare function GetIdOfName(methodname as string) as integer
declare sub invokewrapper(calltype as integer,pretval as integer)
declare sub ACTIVEXinvoke
declare function ACTIVEXgetnum as double  'variant
declare function ACTIVEXgetstr as string
declare sub INTERFACEinvoke
declare function INTERFACEgetnum as double  'variant
declare function INTERFACEgetstr as string
declare sub ConnectEvents(cestring as string)
declare sub DisconnectEvents
declare sub standardEventQueryInterface STD (lpIntf as integer,l_riid as integer,pppvObj as integer)
declare sub standardEventReturn1 STD (lpIntf as integer)
declare sub standardEventNOTIMPL1 STD (lpIntf as integer,lstandardEventNOTIMPL1 as integer)
declare sub standardEventNOTIMPL3 STD (lpIntf as integer,lstandardEventNOTIMPL1 as integer,lstandardEventNOTIMPL2 as integer,lstandardEventNOTIMPL3 as integer)
declare sub standardEventNOTIMPL5 STD (lpIntf as integer,lstandardEventNOTIMPL1 as integer,lstandardEventNOTIMPL2 as integer,lstandardEventNOTIMPL3 as integer,lstandardEventNOTIMPL4 as integer,lstandardEventNOTIMPL5 as integer)
declare sub standardEventInvoke STD (pthis as integer,dispidMember as integer,lpriid as integer,_
  lcid as integer,wFlags as integer,lpdispparams as integer,lpvarResult as integer,_
  lpexcepinfo as integer,puArgErr as integer)
declare sub SetEvent(dispidmember as integer,subptr as integer) 'register an event handler
declare sub INTERFACECreateObject(progid as string)
declare sub ACTIVEXCreateActiveX(progid as string)
declare function GetObject(gos as string) as integer
declare function doqueryinterface(qipointer as integer,qistring as string) as integer
declare function INTERFACEQueryInterface(qistring as string) as integer
declare function ACTIVEXQueryInterface(qistring as string) as integer
declare sub InterfaceAddRef(ipointer as integer)
declare sub InterfaceRelease(ipointer as integer)
declare sub ENUMEnum(enumintf as INTERFACE) 'start enumeration
declare function ENUMNextItem as integer
declare sub ENUMEndEnum

'global variables
defint ComHelperl,ComHelperpsub 'scratch variables
dim void as variant 'variant representing an omitted optional parameter
  void=&h80020004 'DISP_E_PARAMNOTFOUND
  byref(@void)=10 'set variant type to VT_ERROR
dim nullvariant as variant 'variant representing an empty value
  byref(@nullvariant)=1
defint COMRESULT=-1 'set as result of all COM calls. 0=OK. other values mean error
defint COMencoding=0 'change value if you use string arguments not encoded in ANSI, e.g. 936 for Chinese GB encoding, 65001 for UTF-8
'standard event handling interface (implementation of IDispatch)
dim standardEventsVtable(6) as integer
standardEventsVtable(0)=codeptr(standardEventQueryInterface)
standardEventsVtable(1)=codeptr(standardEventReturn1)  'AddRef
standardEventsVtable(2)=codeptr(standardEventReturn1)  'Release
standardEventsVtable(3)=codeptr(standardEventNOTIMPL1) 'GetTypeInfoCount
standardEventsVtable(4)=codeptr(standardEventNOTIMPL3) 'GetTypeInfo
standardEventsVtable(5)=codeptr(standardEventNOTIMPL5) 'GetIDsOfNames
standardEventsVtable(6)=codeptr(standardEventInvoke) 'Invoke

'universal IIDs
dim IID_IDispatch as GUID
 with IID_IDispatch: .d1=&h20400: .d23=0: .d4=&hC0: .d5=&h46000000: end with
dim IID_IUnknown as GUID
 with IID_IUnknown: .d1=0: .d23=0: .d4=&hC0: .d5=&h46000000: end with
dim IID_Null as GUID
 with IID_Null: .d1=0: .d23=0: .d4=0: .d5=0: end with
dim IID_IObjectWithSite as GUID '{FC4801A3-2BA9-11CF-A229-00AA003D7352}
 with IID_IObjectWithSite: .d1=&hFC4801A3: .d23=&h11cf2ba9: .d4=&haa0029a2: .d5=&h52733d00: end with

$ifndef DLL
ComInit 'API declares
$endif

$endif 'end of part 1 -- declarations

'-- part 2 -- implementations
'if this .inc is included in a DLL, then only include it after the END statement

$ifndef ComHelperGenerics2

  '--- black magic
  $ifndef DLL
    $define doComHelperGenerics2
  $else
    $ifdef doComHelperGenerics2nexttime
       $define doComHelperGenerics2
    $else
       $define doComHelperGenerics2nexttime
    $endif
  $endif
  $ifndef doComHelperGenerics2 'stop here for now
  $else
    '--- /black magic

$define ComHelperGenerics2
sub ComInit 
begin runonce
'API declarations
Declare Sub BindMoniker Lib "ole32" (pmk As integer,grfOpt As integer,iidResult As integer,ppvResult As integer)
declare sub CoInitialize Lib "ole32" (CoInitializeReserved as integer)
declare sub CoCreateInstance LIB "ole32" (CoCreateInstancerclsid as GUID,CoCreateInstancepUnkOuter as integer,_
  CoCreateInstancedwClsContext as integer,CoCreateInstanceriid as GUID,_
  CoCreateInstanceppv AS integer) 'as integer
Declare Sub CreateBindCtx Lib "ole32" (reserved As integer,ppbc As integer)
declare function FormatMessageA Lib "kernel32" (FormatMessageFlags as integer,FormatMessageSource as integer,_
  FormatMessageMessageId as integer,FormatMessageLanguageId as integer,FormatMessageBuffer as integer,_
  FormatMessageSize as integer,FormatMessageArguments as integer) as integer
Declare Sub MkParseDisplayName Lib "ole32" (pbc As integer,szUserName As integer,pchEaten As integer,ppmk As integer)
declare function MultiByteToWideChar Lib "kernel32" (CodePage As integer,dwFlags As integer,_
  lpMultiByteStr As integer,cchMultiByte As integer,lpWideCharStr As integer,cchWideChar As integer) As integer
declare function WideCharToMultiByte Lib "kernel32" (CodePage As integer,dwFlags As integer,_
  lpWideCharStr As integer,cchWideChar As integer,lpMultiByteStr As integer,ByVal cchMultiByte As integer, _
  lpDefaultChar As integer, lpUsedDefaultChar As integer) As integer
declare sub AtlAxWinInit lib "ATL.DLL" 'AS LONG
declare function AtlAxCreateControl lib "ATL.DLL" (lpszName as integer, _
  hwin as integer, pStream as integer, ppUnkContainer as integer) as integer
declare function AtlAxGetControl lib "ATL.DLL" (hwin as integer, ppUnkControl as integer) as integer
'declare function AtlAdvise lib "ATL.DLL" (pUnkCP as integer, pUnk as integer, riid as GUID, pdw as integer) as integer
'Declare Sub AtlUnadvise Lib "atl.dll" (pUnkCP As integer, lpiid As integer, dw As integer)
declare sub RtlZeroMemory Lib "kernel32" (lpDestination As integer, Length As integer)
declare function GlobalAlloc Lib "kernel32.dll" (wFlags As integer, dwBytes As integer) as integer
declare sub GlobalFree Lib "kernel32.dll" (hMem As integer) 'As integer
declare function CLSIDFromProgID Lib "ole32.dll" (lpTSzProgID as integer,  pclsid as integer) as integer
declare function CLSIDFromString Lib "ole32.dll" (lpsz as integer, pclsid as integer) as integer

'-- General initialization
CoInitialize(0)
AtlAxWinInit
dim eventconnections as memory 'register of the event connections created
  'each record is 16 bytes long consisting of:
  '.offset0: hbObj of the object
  '.offset4: pointer to the connectionpoint interface
  '.offset8: a pointer to StdEventHandlervtable. The address of this element is what is used to identify the connection when an event is received
  '.offset12: cookie returned by AtlAdvise (necessary to disconnect the event interface)
dim eventtable as memory 'register of event handlers
  'each record is 16 bytes long consisting of:
  '.offset0: address of the pointer to StdEventHandlervtable in eventconnections
  '.offset4: dispID of the event (event code, the one used in SetEvent)
  '.offset8: hbObj of the object
  '.offset12: codeptr of the user-defined sub
$ifdef DLL
'temporary hack when using in dll: artificially extend buffers. Otherwise, generates some crashes (??)
eventconnections.initialize 20000: eventconnections.size=0
eventtable.initialize 20000: eventtable.size=0
$endif
end runonce
end sub '-(ComInit)

'helper subs
'WinErrorMsg: return description of a given error number
function WinErrorMsg
defstr s=space$(261)
ComHelperl=FormatMessageA(&h1200,0,dwError,0,@s,260,0)
s=left$(s,ComHelperl)
s=replacesubstr$(s,chr$(13),null)
s=replacesubstr$(s,chr$(10),null)
result=s
end function

'ANSI: convert a pointer to a unicode string into an ANSI string
function ANSI
ComHelperl=WideCharToMultiByte(COMencoding,0,lps,-1,0,0,0,0)
defstr u=space$(ComHelperl)
ComHelperl=WideCharToMultiByte(COMencoding,0,lps,-1,@u,ComHelperl,0,0)
u=left$(u,isub(ComHelperl,1))
result=u
end function

'setindirect: sets the memory address pointed by a variant.
'(equivalent to byref(v)=i but with a variant argument)
'this is needed because if you write byref(v)=i and v has the byref flag,
'then it is automatically dereferenced
'and you end up doing byref(byref(v))=i (or so it seems to me)
sub setindirect
byref(byref(@setindirectv+8))=setindirecti
end sub

'-- GetIdOfName -- call current object's GetIdsOfNames to find method's dispid
function GetIdOfName
'convert name to unicode
ComHelperl=MultiByteToWideChar(0,0,@methodname,-1,0,0)
defstr wstr=space$(imul(ComHelperl,2))
ComHelperl=MultiByteToWideChar(0,0,@methodname,-1,@wstr,ComHelperl)
defint awstr=@wstr
'get address of object's GetIdsOfNames
ComHelperpsub=byref(byref(byref(hbObj))+20)
defint dispid=0 'result value
callfunc ComHelperpsub,@dispid,&h400,1,@awstr,@IID_Null,byref(hbObj)
COMRESULT=EAX
result=dispid
end function

'--- Standard INVOKE wrapper

sub INTERFACEinvoke
invokewrapper(1,0) 'calling flag=1 (Call)
end sub '-(INTERFACEinvoke)

function INTERFACEgetnum
dim v as variant
invokewrapper(3,@v)  'we set the flags to 3=Call OR set_property. some methods that give a return value want the Call flag anyway
'if byref(@v)=11 then byref(@v)=3
result=v
end function '-(INTERFACEgetnum)

function INTERFACEgetstr
dim v as variant
invokewrapper(3,@v)
'check that result is not null, empty or error
defint vt=byref(@v)
if (vt=0) or (vt=1) or (vt=10) then
  result=null
else
  'convert result to ANSI
  result=ANSI(byref(@v+8)) 'ANSI$(v)
end if
end function '-(INTERFACEgetstr)

sub ACTIVEXinvoke
invokewrapper(1,0)
end sub '-(ACTIVEXinvoke)

function ACTIVEXgetnum
dim v as variant
invokewrapper(3,@v)
result=v
end function '-(ACTIVEXgetnum)

function ACTIVEXgetstr
dim v as variant
invokewrapper(3,@v)
defint vt=byref(@v)
if (vt=0) or (vt=1) or (vt=10) then
  result=null
else
  'convert result to ANSI
  result=ANSI(byref(@v+8)) 'ANSI$(v)
end if
end function '-(ACTIVEXgetstr)

'core of invoke wrapper, used by invoke, getnum and getstr
sub invokewrapper
dim dp as DISPPARAMS
defint propertyput,dispid,argcount,i,vt,l,ArgPtr
'argument count
argcount=byref(iadd(hbArgs,8)): dec(argcount) 'subtract 1 for the method's name
'get method's name (last argument in hbArgs array)
ArgPtr=iadd(hbArgs,imul(argcount,16))
vt=byref(iadd(ArgPtr,16))
if vt=3 then 'method name is an integer -> we assume it is a dispid
  dispid=byref(iadd(ArgPtr,24))
else 'we assume method name is a string and we lookup its dispid
  defstr methodname=variantref$(iadd(ArgPtr,16)
  if lcase$(left$(methodname,4))="set_" then
    propertyput=1
    calltype=4
    methodname=mid$(methodname,5)
  elseif lcase$(left$(methodname,9))="setbyref_" then
    propertyput=1
    calltype=8
    methodname=mid$(methodname,10)
    'transform the 1st argument passed (normally an interface .pointer value) to BYREF
    byref(iadd(hbArgs,16))=&h4009 'VT_BYREF + VT_DISPATCH
    defint byrefparam=byref(iadd(hbArgs,24)) 'value of variant argument
    byref(iadd(hbArgs,24))=@byrefparam
  else
    propertyput=0
  end if
  'get method's dispid
  dispid=GetIdOfName(methodname)
  'showmessage "dispid for "+methodname+" = "+str$(dispid)
  if dispid=-1 then 'sometimes the TypeInfo contains an extra leading "get_" that shouldn't be. Try again without it
    if lcase$(left$(methodname,4))="get_" then
      methodname=mid$(methodname,5)
      dispid=GetIdOfName(methodname)
    end if
  end if
  if dispid=-1 then showmessage "COM error"+chr$(13)+"dispid for "+methodname+" not found": exit sub 'unknown method
end if
'set up parameter array
dp.rgvarg=iadd(hbArgs,16)
dp.cArgs=argcount
if propertyput then
  'some objects don't properly make the difference between Get and Set property calls
  'so you need to indicate a "named argument" with ID -3 (for DISPID_PROPERTYPUT)
  'NOTE: we assume that Set calls have 1 parameter only (the value to set)
  defint DISPID_PROPERTYPUT=-3
  dp.cNamedArgs=1
  dp.rgdispidnamedargs=@DISPID_PROPERTYPUT
else
  dp.cNamedArgs=0
end if
'convert strings to BSTR from their original encoding (defined in COMencoding)
'note: one needs to allocate memory because the BSTR may be longer than the 
'original string, so it won't fit in the original buffer.
defint nRam=0
for i=1 to argcount
  ArgPtr=iadd(hbArgs,imul(i,16))
  vt=byref(ArgPtr) and &hffff
  if vt=30 then
    ComHelperl=MultiByteToWideChar(COMencoding,0,byref(iadd(ArgPtr,8)),-1,0,0)
    l=GlobalAlloc(0,ComHelperl+ComHelperl+4)
    'push buffer address in order to free it later on
    push l
    inc(nRam)
    ComHelperl=MultiByteToWideChar(COMencoding,0,byref(iadd(ArgPtr,8)),-1,iadd(l,4),ComHelperl)
    byref(l)=ComHelperl+ComHelperl-2
    byref(ArgPtr)=8 'type = BSTR
    byref(iadd(ArgPtr,8))=iadd(l,4)
  end if
next
push nRam 'push number of buffers that will have to be freed
'call object's Invoke
ComHelperpsub=byref(byref(byref(hbObj))+24) 'address of Invoke method
callfunc ComHelperpsub,0,0,pretval,@dp,calltype,&h400,@IID_Null,dispid,byref(hbObj)
COMRESULT=EAX
'free string buffers
pop nRam
for i=1 to nRam
  pop l: GlobalFree(l)
next
if methodname="isTextEdit" then showmessage "retval: "+hex$(byref(pretval))+" "+hex$(byref(pretval+8))
end sub '-(ACTIVEXinvokewrapper)

'--- ActiveX event handling
sub standardEventQueryInterface: byref(pppvObj)=lpIntf: retval 0: end sub  'return same
sub standardEventReturn1: retval 1: end sub 'return 1
sub standardEventNOTIMPL1: retval &h80004001: end sub 'E_NOTIMPL
sub standardEventNOTIMPL3: retval &h80004001: end sub 'E_NOTIMPL
sub standardEventNOTIMPL5: retval &h80004001: end sub 'E_NOTIMPL
sub standardEventInvoke 'call apropriate event handler
'pthis=@@standardEventsVtable
asm push ebx: asm push esi: asm push edi: asm push ecx 'save registers
'lookup event handler from eventtable
defint nbevents=ComIniteventtable.size: idiv(nbevents,16)
defint i
for i=0 to isub(nbevents,1)
  ComIniteventtable.position=imul(i,16)
  defint thiseventhandler=ComIniteventtable.readnum(4)
  if thiseventhandler=pthis then
    defint thisdispid=ComIniteventtable.readnum(4)
    if thisdispid=dispidMember then goto EventInvoke_found
'if dispidMember=250 then showmessage "thiseventhandler: "+hex$(thiseventhandler)
  end if
next
'event not found in table
goto standardEventInvoke_end 'exit sub
EventInvoke_found:
'read hbObj and sub address from eventtable
hbObj=ComIniteventtable.readnum(4) 'this way, hbObj is set when entering the event handler, allowing the user to use object methods naturally in the sub
defint psub=ComIniteventtable.readnum(4)
if psub=0 then goto standardEventInvoke_end 'exit sub
'call the user-defined function, passing the parameters as variants
defint nbparam=byref(iadd(lpdispparams,8)) 'DISPPARAMS.Count
defint paramarray=byref(lpdispparams)
for i=0 to isub(nbparam,1)
  defint lpparam=iadd(paramarray,imul(i,16))
  defint vt=byref(lpparam) 'and &hffff
  'byref parameters
  'if vt and &h4000 then byref(lpparam)=3 'DWORD 'VT_byref: change vt to DWORD else HotBasic may get confused when using the variant
  if vt=&h400c then 'variant BYREF: dereference pointer so as to expose the variant that is pointed to
    memcpy lpparam,byref(iadd(lpparam,8)),16
    vt=byref(lpparam)
  end if
  'convert unicode strings to ANSI
  if vt=8 or vt=31 then 'unicode string
    lps=byref(iadd(lpparam,8))
    if lps then
      ComHelperl=WideCharToMultiByte(0,0,lps,-1,0,0,0,0) 'length
      if ComHelperl=1 then 'empty string
      lpparam=@nullvariant 'null string
    else
      defstr ansistr=space$(iadd(ComHelperl,1)) 'allocate buffer
      ComHelperl=WideCharToMultiByte(0,0,lps,-1,@ansistr,ComHelperl,0,0) 'convert to ANSI
      memcpy lps,@ansistr,isub(ComHelperl,1) 'copy back to lps
      'note: this works because the ANSI string is always shorter than the unicode so we have enough buffer.
      RtlZeroMemory(iadd(lps,isub(ComHelperl,1)),1) 'add terminating null
      byref(lpparam)=30 'set type to VT_LPSTR
    end if
  else
    lpparam=@nullvariant
  end if
end if
push lpparam
next
callfunc psub
standardEventInvoke_end:
asm pop ecx: asm pop edi: asm pop esi: asm pop ebx 'restore
retval 0 'OK
end sub '-(standardEventInvoke)

sub SetEvent
'identify event connection: we use the latest one registered with the object
defint me=hbObj
defint i,nbconnections=ComIniteventconnections.size: idiv(nbconnections,16)
for i=nbconnections-1 to 0 step -1
  ComIniteventconnections.position=imul(i,16)
  defint thisobj=ComIniteventconnections.readnum(4)
  if thisobj=me then
    'check that connection is not null, which would indicate that the connection has been disconnected
    ComIniteventconnections.position=imul(i,16)+8
    defint thispeventhandler=ComIniteventconnections.readnum(4)
    if thispeventhandler then goto SetEvent_foundconnection
  end if
next
'no event handler connected for that object
COMRESULT=&h80000003 'invalid arg
exit sub
SetEvent_foundconnection:
'compute address of the copy of pStdeventhandler corresponding to this connection. This is what identifies the connection when we receive an event.
defint thiseventhandler=@ComIniteventconnections+imul(i,16)+8
'look if the event was already in eventtable
defint nbevents=ComIniteventtable.size: idiv(nbevents,16)
for i=0 to isub(nbevents,1)
  ComIniteventtable.position=imul(i,16)
  defint thiseventhandler2=ComIniteventtable.readnum(4)
  defint thisdispid=ComIniteventtable.readnum(4)
  if (thiseventhandler2=thiseventhandler) and (thisdispid=dispidmember) then _
    ComIniteventtable.position=ComIniteventtable.position-8: goto SetEvent_writeevent
next
'event was not already registered -> append it
ComIniteventtable.position=ComIniteventtable.size
SetEvent_writeevent:
'write new entry in eventtable
ComIniteventtable.writenum thiseventhandler,4 'interface pointer of the event interface
ComIniteventtable.writenum dispidmember,4     'event number
ComIniteventtable.writenum me,4   'object's hbObj
ComIniteventtable.writenum subptr,4 'address of user-defined event handler (can be zero to cancel event)
end sub '-(SetEvent)

'-- standard object creators

sub INTERFACECreateObject
defstr s
'convert progID to Unicode
ComHelperl=MultiByteToWideChar(0,0,@progid,-1,0,0)
defstr wprogid=space$(iadd(ComHelperl,ComHelperl))
ComHelperl=MultiByteToWideChar(0,0,@progid,-1,@wprogid,ComHelperl)
'try to convert to CLSID
dim myID as GUID
if CLSIDFromProgID(@wprogid,@myID) then
  'if it fails, then try to convert it from CLSID string (between {})
  if CLSIDFromString(@wprogid,@myID) then
    'if that also fails
    showmessage "Couldn't find Class ID of object, type:"+chr$(13)+progid
    exit sub
  end if
end if
'create object and get its IDispatch, in order to give access to Invoke
CoCreateInstance(myID,0,21,IID_IUnknown,hbObj)  'CLSCTX_ALL
COMRESULT=EAX
if COMRESULT then 
  s=WinErrorMsg(COMRESULT)
  s="Creation of object failed, type:"+chr$(13)+progid+chr$(13)+s+" (&h"+hex$(COMRESULT)+")"
  showmessage s
end if
ComHelperpsub=byref(byref(byref(hbObj))) 'QueryInterface
callfunc ComHelperpsub,hbObj,@IID_IDispatch,byref(hbObj)
COMRESULT=EAX
if COMRESULT then 
  s=WinErrorMsg(COMRESULT)
  s="Couldn't get IDispatch of object, type:"+chr$(13)+progid+chr$(13)+s+" (&h"+hex$(COMRESULT)+")"
  showmessage s
end if
end sub

sub ACTIVEXCreateActiveX
defstr s
'convert progID to Unicode
ComHelperl=MultiByteToWideChar(0,0,@progid,-1,0,0)
defstr wprogid=space$(iadd(ComHelperl,ComHelperl))
ComHelperl=MultiByteToWideChar(0,0,@progid,-1,@wprogid,ComHelperl)
'create control and bind it to hWnd
COMRESULT=AtlAxCreateControl(@wprogid,hbHnd,0,0)
if COMRESULT then 
  s=WinErrorMsg(COMRESULT)
  s="Creation of "+progid+" object failed:"+chr$(13)+s+" (&h"+hex$(COMRESULT)+")"
  showmessage s
end if
'get IUnknown interface of the object created
COMRESULT=AtlAxGetControl(hbHnd,hbObj) 'get IUnknown of the control
if COMRESULT then 
  s=WinErrorMsg(COMRESULT)
  s="Creation of "+progid+" object failed:"+chr$(13)+s+" (&h"+hex$(COMRESULT)+")"
  showmessage s
end if
'attach event interface
'COMRESULT=AtlAdvise(byref(hbObj),@pstandardEventsVtable,IID_IDispatch,@ComHelperl)
ConnectEvents(null)
'if COMRESULT then showmessage "Connection of "+progid+" event handler failed:"+chr$(13)+WinErrorMsg(COMRESULT)+" (&h"+hex$(COMRESULT)+")"
'QueryInterface to get IDispatch interface of the object created
ComHelperpsub=byref(byref(byref(hbObj))) 'QueryInterface
'and store it in .pointer
callfunc ComHelperpsub,hbObj,@IID_IDispatch,byref(hbObj)
COMRESULT=EAX
if COMRESULT then 
  s=WinErrorMsg(COMRESULT)
  s="Creation of "+progid+" object failed:"+chr$(13)+s+" (&h"+hex$(COMRESULT)+")"
  showmessage s
end if
end sub

function GetObject 'get automation object from an identifier
'create a bindctx
dim bindctx as integer
CreateBindCtx(0,@bindctx)
'create an IMoniker
dim monik as integer
defint ilen=MultiByteToWideChar(0,0,@gos,-1,0,0)
defstr wsmonik: wsmonik.initialize iadd(ilen,ilen)
ilen=MultiByteToWideChar(0,0,@gos,-1,@wsmonik,ilen)
MkParseDisplayName(bindctx,@wsmonik,@ilen,@monik)
'get a pointer to the object
defint o
BindMoniker(monik,0,@IID_IDispatch,@o)
result=o
end function '-(GetObject)

'-- QueryInterface wrappers
'input: the GUID of an interface, represented as a string, like "{332C4425-26CB-11D0-B483-00C04FD90119}"
'output: a pointer to the interface (if the object supports that interface)
function doqueryinterface(qipointer as integer,qistring as string) as integer
if qipointer=0 then result=0: COMRESULT=&h80000005 'INVALID_POINTER
'convert the string to a GUID
dim id as GUID
with id
.d1=hex2dw(mid$(qistring,2,8))
.d23=hex2dw(mid$(qistring,16,4))shl 16 + hex2dw(mid$(qistring,11,4))
.d4=hex2dw(mid$(qistring,28,2)+mid$(qistring,26,2)+mid$(qistring,23,2)+mid$(qistring,21,2))
.d5=hex2dw(mid$(qistring,36,2)+mid$(qistring,34,2)+mid$(qistring,32,2)+mid$(qistring,30,2))
end with
'address of the QueryInterface sub
defint psub=byref(byref(qipointer))
defint res
'showmessage hex$(psub)
callfunc psub,@res,@id,qipointer
COMRESULT=EAX
result=res
end function

function INTERFACEQueryInterface(qistring as string) as integer
result=doqueryinterface(byref(hbObj),qistring)
end function

function ACTIVEXQueryInterface(qistring as string) as integer
result=doqueryinterface(byref(hbObj),qistring)
end function

sub InterfaceAddRef(ipointer as integer)
if ipointer then
  defint prelease=byref(byref(ipointer)+4)
  callfunc prelease,ipointer 'release
end if
end sub

sub InterfaceRelease(ipointer as integer)
if ipointer then
  defint prelease=byref(byref(ipointer)+8)
  callfunc prelease,ipointer 'release
end if
end sub

'-- CONNECTEVENTS: connect an event interface to an object.
'The string 'cestring' is the GUID of the event interface requested.
'An entry is created in 'eventconnections', identifying the connection.
'Note: you can connect several event interfaces at the same time to the same object. I am not sure this is allowed by the COM doctrine
'but I can see no harm, as long as you are sure that the different event interfaces do not use the same event ID numbers.
sub ConnectEvents(cestring as string)
'keep object handle
defint psub,me=hbObj
'Check that this is a connectable object.
dim CPC as INTERFACE 'IConnectionPointContainer
CPC.pointer=doqueryinterface(byref(me),"{B196B284-BAB4-101A-B69C-00AA00341D07}") 'IConnectionPointContainer
'InterfaceAddRef(CPC.pointer)
if (COMRESULT<>0) or (CPC.pointer=0) then exit sub
'Connect to the appropriate connection point
defint pCP 'IConnectionPoint
dim id as GUID
if cestring.len then
  'if an event interface ID is specified, convert it to a GUID and use it
  with id
    .d1=hex2dw(mid$(cestring,2,8))
    .d23=hex2dw(mid$(cestring,16,4))shl 16 + hex2dw(mid$(cestring,11,4))
    .d4=hex2dw(mid$(cestring,28,2)+mid$(cestring,26,2)+mid$(cestring,23,2)+mid$(cestring,21,2))
    .d5=hex2dw(mid$(cestring,36,2)+mid$(cestring,34,2)+mid$(cestring,32,2)+mid$(cestring,30,2))
  end with
  'Find the connection point.
  psub=byref(byref(CPC.pointer)+16) 'address of FindConnectionPoint
  callfunc psub,@pCP,@id,CPC.pointer 'CPC.invoke("FindConnectionPoint",riid,@CP)
else 'no event interface ID is specified -> get object's default connection point
  'first, try to get a connection by requesting IDispatch. It seems to work in some cases and returns the default event interface.
  psub=byref(byref(CPC.pointer)+16) 'address of FindConnectionPoint
  callfunc psub,@pCP,@IID_IDispatch,CPC.pointer 'CPC.FindConnectionPoint IDispatch,@CP
  COMRESULT=EAX
  if (COMRESULT<>0) or (pCP=0) then
    'if it doesn't work, request the 1st connection exposed by EnumConnectionPoints
    dim penum as INTERFACE 'IEnumConnectionPoints
    psub=byref(byref(CPC.pointer)+12)
    callfunc psub,@penum,CPC.pointer 'CPC.EnumConnectionPoints
    COMRESULT=EAX
    if (COMRESULT<>0) or (penum.pointer=0) then
      'InterfaceRelease(CPC.pointer): exit sub
    else
       psub=byref(byref(penum.pointer)+12) 'penum.Next
       callfunc psub,0,@pCP,1,penum.pointer
       ''InterfaceRelease(penum.pointer)
    end if
  end if
end if
COMRESULT=EAX
if (COMRESULT<>0) or (pCP=0) then exit sub 'InterfaceRelease(CPC.pointer): exit sub
'InterfaceAddRef(pCP)
'Create new entry in eventconnections
defint ComIniteventconnectionsoldsize=ComIniteventconnections.size
ComIniteventconnections.position=ComIniteventconnectionsoldsize
ComIniteventconnections.writenum me,4 'object's hbObj
ComIniteventconnections.writenum pCP,4 'pointer to the IConnectionPoint interface
'create a copy of the event handler interface pointer and store it in eventconnections
'showmessage "ConnectEvents: "+hex$(@eventconnections+eventconnections.position)
defint pstandardEventsVtable=@standardEventsVtable
ComIniteventconnections.writenum pstandardEventsVtable,4
defint intfpointer=@ComIniteventconnections+ComIniteventconnections.position-4
'Advise the connection point
psub=byref(byref(pCP)+20) 'CP.Advise
defint cookie
callfunc psub,@cookie,intfpointer,pCP 'cookie=CP.Advise (intfpointer)
COMRESULT=EAX
'InterfaceRelease(CPC.pointer) 
if (COMRESULT<>0) or (cookie=0) then
  'connection failed
  ComIniteventconnections.size=ComIniteventconnectionsoldsize 'unwrite new entry in eventconnections
  'InterfaceRelease(pCP)
  exit sub
end if
ComIniteventconnections.writenum cookie,4 'connection identifier (used if we want to disconnect)
end sub '-(ConnectEvents)

'--DISCONNECTEVENTS: disconnect ALL event interfaces connected to the object
'* future improvement: erase corresponding events from eventtable
sub DisconnectEvents
defint i,nbconnections=ComIniteventconnections.size: idiv(nbconnections,16)
COMRESULT=0
defint hr2,hr=0
defint zer=0
for i=0 to isub(nbconnections,1)
  ComIniteventconnections.position=imul(i,16)
  defint thisobj=ComIniteventconnections.readnum(4)
  if thisobj=hbObj then
    'disconnect
    defint lpconnectionpoint=byref(@ComIniteventconnections+imul(i,16)+4)
    if lpconnectionpoint then
      ComIniteventconnections.position=imul(i,16)+12
      defint cookie=ComIniteventconnections.readnum(4)
      defint psub=byref(byref(lpconnectionpoint)+24) 'IConnectionPoint.Unadvise
      callfunc psub,cookie,lpconnectionpoint
      hr2=EAX 'error code
      if hr=0 then hr=hr2
      'erase entry in eventconnections
      'InterfaceRelease(lpconnectionpoint)
      ComIniteventconnections.position=imul(i,16)
      ComIniteventconnections.writenum zer,4
      ComIniteventconnections.writenum zer,4
      ComIniteventconnections.writenum zer,4
      ComIniteventconnections.writenum zer,4
    end if
  end if
next
COMRESULT=hr
end sub '-(sub DisconnectEvents)

'-- ENUM subs
sub ENUMEnum
defint h=hbObj
defint retadd
pop retadd: push retadd: byref(iadd(h,4))=0 'self.loopstart=retadd 'peek return address from the stack, it is the beginning of the loop
byref(h)=enumintf.getnum("_NewEnum") 'self.pointer= '"enumeration" of the objects in the collection
if byref(h) then
  defint nextfunction=byref(byref(byref(h))+12) 'byref(byref(self.pointer)+12)
  byref(iadd(h,8))=nextfunction 'self.nextfunction=nextfunction 'refuses to compile
else
  showmessage "Error in .Enum: The collection does not support object enumeration."
end if
end sub

function ENUMNextItem
'get next item in enumeration
dim vadd as variant
defint nextfunc=byref(iadd(hbObj,8)) 'self.nextfunction
callfunc nextfunc,0,@vadd,1,self.pointer 'vadd receives a pointer to the next object
'save result in .lastresult
byref(iadd(hbObj,12))=vadd 'self.lastresult=vadd
result=byref(iadd(hbObj,12)) 'self.lastresult
end function

sub ENUMEndEnum
if byref(iadd(hbObj,12)) then 'self.lastresult<>0 then
  'last result was not null, continue loop
  defint padd
  pop padd: padd=byref(iadd(hbObj,4)): push padd 'self.loopstart 'substitute return address
else
  'last result was zero, loop ends. reset ENUM object
  InterfaceRelease(self.pointer) 'release IEnumVARIANT
  self.pointer=0: byref(iadd(hbObj,4))=0: byref(iadd(hbObj,8))=0 'self.loopstart=0: self.nextfunction=0
end if
end sub

'--- black magic
    $endif 'doComHelperGenerics2
'--- /black magic

$endif 'ComHelperGenerics2 -end of part 2 -- implementation
$equalprec off
