$optimize
'HotStrip Browser Copyright 2012 James J Keene
'updated Aug 11, 2012
$apptype gui: $typecheck on

EXTERNAL fAddingBookMark,fBUSY
EXTERNAL i0,i1,i2,fHnd,tvHnd,g1Hnd
EXTERNAL OPfavpath,OPfavtree,OPtrackers,OPhtml,OPhtml1

App.icon="ico\Minus.ico"
$xpstyle
$resource add_ico as "ico\Add.ico"
$resource back_ico as "ico\Back.ico"
$resource done_ico as "ico\Done.ico"
$resource down_ico as "ico\Download.ico"
$resource fav_ico as "ico\Fav.ico"
$resource go_ico as "ico\Go.ico"
$resource load_ico as "ico\Loading.ico"
$resource next_ico as "ico\Next.ico"
$resource stop_ico as "ico\Stop.ico"
$resource TV_BMP as "ico\TreeView.bmp"

defstr base,base1,cache,cache0,url,main,nav,t$,u$,v$,trackers,file$
defstr res_type,slash,profile,favpath,fav0,fav1
defstr html, html1
defstr title$="HotStrip Browser 2.1 "
defint r,i,j,maxURL,iURL=-1
defint fBUSY,fCNTRL,fDO,fGO,fGO1,fAddingBookMark,fQuery 'flags
defint nPixel=32
defint i0,i1,i2,fHnd,tvHnd,g1Hnd

if version.platform<=one then
  showmessage "Requires Windows NT, 2K, XP or higher"
  app.terminate
end if
$include "activex.inc"
$include "hotstrip.inc"
$include "stripfrm.inc"

'startup stuff
if fileexists("trackers.ini") then trackers.loadfromfile "trackers.ini"
if not direxists("cache") then mkdir "cache"
if not direxists("download") then mkdir "download"
fHnd=f: tvHnd=tv1: g1Hnd=g1 'put handles in ext vars
gosub clear_cache
wb.invoke("set_RegisterAsBrowser",true)
profile=environ$("userprofile"): favpath=profile+"\Favorites\"
LoadFavorites
hbLoop=codeptr(key_hbLoop) 'trap back key

'''''Note gui loop design here to end statement
f.show: doevents
main=command$(1)
if main.len then fDO=one else wb.invoke("GoHome")

f_loop:
doevents: sleep 0.15
if fBUSY THEN goto f_loop 'wait until url_go completes
fGO=wb.getnum("get_ReadyState")
'reset icons on "complete=4"
if fGO=4 and fGO<>fGO1 then fGO1=fGO: gosub url_stop1: fQuery=zero
if fDO THEN gosub url_go  'call url_go if task pending
if iURL<maxURL then bnext.visible=true else bnext.visible=false
if iURL>zero then bback.visible=true else bback.visible=false
goto f_loop
END
'''''

url_go0:
main=ed1.text
burl.onclick=zero 'turn off event
url_go:
fBUSY=one: fDO=zero: fQuery=zero: ProgressChange(10)
gosub book_hide: gosub hist_hide
if instr(main,"/search?") then nav=main: goto url_navigate2
if left$(main,7)="mailto:" then nav=main: goto url_navigate2
'check/fix url prefix
j=instr(main,"//")
if j then
  inc(j): res_type=left$(main,j)
else
  main=insert$(main,"http://",1): j=7
end if
res_type=left$(main,j)
if not instr("file://http://https://",res_type then _
  showmessage "Unsupported resource type"+crlf+main: goto url_done
if res_type="file://" then slash="\" else slash="/"

'extract base from url; get last /
r=iadd(j,1): file$.clear
i=InstrLast(r,main,slash)
if i then
  base=mid$(main,r,isub(i,r)): file$=mid$(main,iadd(i,one))
  i=instr(file$,"#"): if i then dec(i): file$=left$(file$,i)
else
  base=mid$(main,r)
end if
'make base tag in base1
base1.clear: base1.append "<base href=",quote,res_type,base,slash,quote," />"

i=url.indexof(main) 'is url in history?
if i<zero then
  gosub url_new
else
  iURL=i 'yes
end if
ed1.text=main: doevents

'make cache filename
'cache0=cache 'save last
if file$.len then
  cache="cache\"+file$
else
  base=replacesubstr$(base,slash,"_")
  cache="cache\"+base+str$(iURL)
end if

'if base=base0 then kill path$+cache
if fileexists(path$+cache) then goto url_navigate 'use cache

status.text="Downloading "+main
burl.icon="down_ico": burl.hint="Downloading file"
burl.onclick=zero: doevents
select case res_type
case "http://","https://"
  r=URL2File(main,cache)
  if r then
    gosub burl_done 'set icon
    status.text="ERROR "+hex$(r): doevents
    if hbConsole then
      t$.clear: t$.additems "Failed to obtain URL:",main,"ERROR="+hex$(r)
      print t$
    end if
    goto url_done
  end if
case "file://"
  t$=mid$(main,8): copy t$, path$+cache: chdir app.path
case else: goto url_done
end select

'is txt document?
if right$(cache,4)=".txt" then goto url_navigate
burl.icon="load_ico": burl.hint="Loading URL"

html.loadfromfile cache
'strip <?xml prefix tag
i=instr(html,"<!DOCTYPE")
if i>one then html=mid$(html,i)

'is html document?
html1=lcase$(html)
if instr(html1,"<html") then goto html_base

'not html or txt
ProgressChange(100)
if not file$.len then goto url_done
with savedlg
  .FileName=file$
  .InitialDir=app.path+"download"
  .Caption="Choose Folder to Save DownLoad"
  .DefExt=null
  .Flags=&H20280E '&H202806 or &H8
end with
if savedlg.execute then html.savetofile savedlg.FileName
gosub burl_done
html.clear: html1.clear: goto url_done

'insert base tag
html_base:
i=instr(html1,"<head")
if i then
  j=instr(i,html,">"): inc(j)
  html=insert$(html,base1,j)
end if

'process html
if instr(html,"_blank") then  'remove _blank targets
  status.text="Removing _blank references": doevents
  html=replacesubstr$(html,"_blank",null)
end if
status.text="Stripping tags...": doevents

if mscript.checked then
  HtmlStrip("<script","</script>"): doevents
  HtmlStrip("<applet","</applet>"): doevents
  OnEventStrip
end if
ProgressChange(60)
if mtrack.checked then HtmlStrip("<a ","</a>"): doevents
if miframe.checked then HtmlStrip("<iframe","</iframe>")
if mobject.checked then HtmlStrip("<object","</object>")
'if View:Show Images is unchecked then strip <img tags:
if mimage.checked=zero then HtmlStrip("<img",">"): doevents
'check for any remaining refs to trackers:
i1=one: i=InstrList(trackers)
if i then
  t$="WARNING: tracker link(s) found": status.text=t$
  if hbConsole then print t$
else
  status.text="Saving edited html..."
end if
doevents
html.savetofile cache: html.clear: html1.clear

url_navigate:
badd.icon="stop_ico": badd.hint="Stop": badd.onclick=url_stop
nav="file://"+path$+cache
url_navigate1:
if fileexists(path$+cache) then
  if FILEREC.size <10 then goto url_done
  url_navigate2:
  wb.invoke("Navigate2",nav,void,void,void,void)
end if
url_done:
fBUSY=zero: goto wb_focus

url_new:
INC(iURL)
if iURL>maxURL then
  maxURL=iURL: url.additems main
else
  url.replace iURL,main
end if
return

url_stop:
wb.invoke("Stop")
fAddingBookMark=zero

url_stop1:
gosub burl_done

badd_icon:
badd.icon="add_ico": badd.hint="Bookmark this page": badd.onclick=book_add
fAddingBookMark=zero
doevents: return

book_add:
if fAddingBookMark then return else fAddingBookMark=one
fav1=ed1.text
fav0.clear: fav0.additems "[DEFAULT]"
fav0.additems "BASEURL="+fav1,"[InternetShortcut]","URL="+fav1
fav0.additems "IDList=","[{000214A0-0000-0000-C000-000000000046}]"
fav1=base+".url"
if left$(fav1,4)="www." then fav1=mid$(fav1,5)
i=instr(fav1,".com"): if i then fav1=delete$(fav1,i,4)
fav1=replacesubstr$(fav1,"/","_")
v$="Folders"+chr$(0)+"*.xxx"+chr$(0)
with savedlg
  .FileName=fav1
  .Filter=v$
  .InitialDir=favpath
  .Caption="Choose Folder to Save BookMark"
  .DefExt="url"
  .Flags=&H20280E '&H202806 or &H8
end with
if savedlg.execute then
  v$=opendlg.FileName: if right$(v$,4)<>".url" then goto add_done
  if left$(v$,favpath.len)<>favpath then goto add_done
  fav0.savetofile v$
  doevents: LoadFavorites
end if
add_done:
fAddingBookMark=zero
return

book_hide:
book.visible=false: doevents: return

book_key:
IF wParam=27 THEN goto book_hide
return

book_show:
book.top=f.top+50+nPixel
i=f.left-book.width
if i<zero then i=zero
book.left=i
book.visible=true: tv1.focus: doevents: return

book_size:
tv1.width=book.clientwidth
tv1.height=book.clientheight
return

burl_done:
burl.icon="done_ico": burl.hint="Done": doevents
return

clear_cache:
DeleteAllFiles("cache"): doevents: return

clear_cookies:
DeleteAllFiles(profile+"\Cookies"): doevents: return

ed1_keyup:
if wParam=13 then goto url_go0
burl.icon="go_ico": burl.hint="Navigate": burl.onclick=url_go0: doevents
return

f_close:
'can save settings here
gosub clear_cache
wb.invoke("Quit")
app.terminate
return

f_msg:
IF uMsg=7 then gosub wb_focus
retval zero: return

f_resize:
wb.height=f.clientheight-nPixel
wb.width=f.clientwidth
status.width=f.clientwidth-status.left
return

file_open:
with opendlg
  .InitialDir=path$
  .Caption="Open Web Page File"
  .DefExt=null
  .Flags=&H205800
end with
if opendlg.execute then _
  main="file://": main.append opendlg.FileName: fDO=one
doevents: return

hist_key:
if wParam=13 then
  hist_sel:
  i=histlb.itemindex: main=histlb.item(i): fDO=one: return
end if
IF wParam<>27 THEN return

hist_hide:
hist.visible=false: doevents: return

hist_show:
hist.top=f.top+50+nPixel
i=f.left-hist.width
if i<zero then i=zero
hist.left=i
histlb.clear
for i=0 to maxURL
histlb.additems url.item(i): doevents
next i
hist.visible=true: histlb.itemindex=iURL: histlb.focus: doevents
return

hist_size:
histlb.width=hist.clientwidth
histlb.height=hist.clientheight
return

key_hbLoop:
defint wP=byref(iadd(hbMsg,8)) 
if byref(iadd(hbMsg,4))=&H100 then 'keydown
  if wP=&H11 then fCNTRL=one: goto hbLoop_done
  if fCNTRL then
    if wP=&H25 then goto nav_back1
    if wP=&H27 then goto nav_forward1
  end if
  goto hbLoop_done
end if
if byref(iadd(hbMsg,4))=&H101 then 'keyup
  if wP=&H11 then fCNTRL=zero
end if
hbLoop_done:
retval zero: return

malloff_click:
miframe.checked=false: mobject.checked=false
mscript.checked=false: mtrack.checked=false
goto clear_cache

mallon_click:
miframe.checked=true: mobject.checked=true
mscript.checked=true: mtrack.checked=true
goto clear_cache

miframe_click:
if miframe.checked then miframe.checked=false else miframe.checked=true
goto clear_cache

mimage_click:
if mimage.checked then mimage.checked=false else mimage.checked=true
goto clear_cache

mobject_click:
if mobject.checked then mobject.checked=false else mobject.checked=true
goto clear_cache

mscript_click:
if mscript.checked then mscript.checked=false else mscript.checked=true
goto clear_cache

mtrack_click:
if mtrack.checked then mtrack.checked=false else mtrack.checked=true
goto clear_cache

nav_back:
if uMsg=&H204 then goto hist_show 'WM_RBUTTONDOWN
nav_back1:
if iURL>zero then kill cache: dec(iURL): goto nav_new

nav_forward:
if uMsg=&H204 then goto hist_show 'WM_RBUTTONDOWN
nav_forward1:
if iURL<maxURL then
  inc(iURL)
  nav_new:
  main=url.item(iURL)
  nav_do:
  fDO=one: ed1.text=main: doevents
end if
return

page_source:
run "notepad "+path$+cache: doevents: return

refresh_page:
kill path$+cache: goto nav_new

show_about:
f.showabout title$+"#Script-free, Anti-Tracking Browser",_
  title$+"Copyright 2012 James J Keene"+CRLF+"http://www.hotbasic.org/"
return

show_console:
if mconsole.checked then
  mconsole.checked=false: freeconsole
else
  mconsole.checked=true: showconsole
end if
doevents: return

show_manual:
main="file://"+path$+"hotstrip.html": fDO=one
return

SUB tv1_select
'get selected Favorite text
if uMsg<>&H4E then retval zero: exit sub 'WM_NOTIFY?
if ior(fAddingBookMark,fBUSY) then retval zero: exit sub
'if wParam<>tv1.ID then retval zero: return 'OS error if not equal!!
if byref(iadd(lParam,8))<>-402 then retval zero: exit sub 'code=TVN_SELCHANGED?
r=byref(iadd(lParam,60)) 'get new TV_ITEM handle
fav0=tv1.item(r)+".url"
use favtree as list with OPfavtree
favtree.position=zero
for i=1 to favtree.itemcount
fav1=favtree.readline
if instr(fav1,fav0) then goto tvsel_do
next i: goto tvsel_done
tvsel_do:
fav0=favpath+fav1
if fileexists(fav0)=zero then goto tvsel_done
fav1.loadfromfile fav0 'load selected Favorite
fav1.position=zero
while fav1.position<fav1.length
fav0=fav1.readline
if left$(fav0,4)="URL=" then
  main=mid$(fav0,5): status.text="Loading "+main
  doevents: fDO=one: exit while
end if
end while
fav0.clear: fav1.clear
tvsel_done:
end use favtree
retval one
END SUB
'''''

wb_focus:
wb.focus: doevents: return
'''''

'.onBeforeNavigate2 -- Fired when a new hyperlink is being navigated to.
declare sub onBeforeNavigate2 STD _
   (vpDisp as variant, _ ' DWORD [VT_DISPATCH] 
    vURL as variant, _ ' VARIANT [VT_VARIANT] 
    vFlags as variant, _ ' VARIANT [VT_VARIANT] 
    vTargetFrameName as variant, _ ' VARIANT [VT_VARIANT] 
    vPostData as variant, _ ' VARIANT [VT_VARIANT] 
    vHeaders as variant, _ ' VARIANT [VT_VARIANT] 
    vCancel as variant) ' DWORD LONG [VT_BOOL]  [byref] 
sub onBeforeNavigate2
begin runonce
defstr Url
end runonce
Url=vURL: doevents
if hbConsole then
  print "onBeforeNavigate=";Url
end if
'cancel these:
if lcase$(left$(Url,7))="mailto:" then
  run "rundll32.exe url.dll,FileProtocolHandler "+Url
  goto cancel_nav
end if
if instr(Url,"javascript:") then goto cancel_nav
if instr(Url,"about:") then goto cancel_nav
'do these:
i=instr(Url,"?"): if i then
  i=instr(i,Url,"http://"): if i then
    Url=mid$(Url,i): i=instr(Url,"&")
    if i then dec(i): Url=left$(Url,i)
    goto do_nav
  end if
  if instr(Url,"/search") then
    if not fQuery then 
      main=Url: gosub url_new: ed1.text=Url: gosub url_stop1
    else
      fQuery=one
    end if
  end if
  exit sub
end if
if instr(Url,"//") then
  do_nav:
  main=Url: fDO=one: ed1.text=Url: doevents
  cancel_nav:
  setindirect(vCancel,1)
end if
end sub

'.onProgressChange -- Fired when download progress is updated.
declare sub onProgressChange STD _
   (vProgress as variant, _ ' LONG [VT_I4]  
    vProgressMax as variant) ' LONG [VT_I4]  
sub onProgressChange
defint Max=vProgressMax
if Max then ProgressChange(100*vProgress/Max)
end sub

'.onStatusTextChange -- Statusbar text changed.
declare sub onStatusTextChange STD _
   (vText as variant) ' STRING [VT_BSTR]  
sub onStatusTextChange
begin runonce
defstr New,Last
end runonce
New=vText
if not New.len then exit sub
if New<>Last then
  Last=New: status.text=New
  if hbConsole then print New
  if New="Done" then
    ProgressChange(100): fGO=zero: gosub url_stop1
  end if
end if
end sub

'.onTitleChange -- Document title changed.
declare sub onTitleChange STD _
   (vText as variant) ' STRING [VT_BSTR]  
sub onTitleChange
f.caption=title$+vText: doevents
end sub

'.onNavigateError -- Fired when a binding error occurs (window or frameset element).
declare sub onNavigateError STD _
   (vpDisp as variant, _ ' DWORD [VT_DISPATCH] 
    vURL as variant, _ ' VARIANT [VT_VARIANT] 
    vFrame as variant, _ ' VARIANT [VT_VARIANT] 
    vStatusCode as variant, _ ' VARIANT [VT_VARIANT] 
    vCancel as variant) ' DWORD LONG [VT_BOOL]  [byref] 
sub onNavigateError
defint I
setindirect(vCancel,1)
I=vStatusCode  ': v$=WinErrorMsg(I): 
status.text="ERROR "+hex$(I): dec(iURL): gosub url_stop1: doevents
end sub
