'requires comport Loopback Connector on com2
$APPTYPE CONSOLE
randomize timer
color 15: print "HotBasic COMPORT Object Random Inputs": color 7

TYPE COMMTIMEOUTS
  ReadIntervalTimeout as LONG = -1  'immediate return
  ReadTotalTimeoutMultiplier as LONG 
  ReadTotalTimeoutConstant as LONG
  WriteTotalTimeoutMultiplier as LONG 
  WriteTotalTimeoutConstant as LONG 
END COMMTIMEOUTS

declare sub SetCommTimeouts LIB "kernel32" _
 (hComm as LONG, CTO as COMMTIMEOUTS)

dim c2 as comport, b as byte
dim t1 as timer
dim i as long
defbyte a = 65  'for "A"

c2.open("com2",2)  'read/write
SetCommTimeouts(c2.handle,CTO)  'set 0 timeout for read

'simulate external device sending data at random intervals
t1.interval=200  'milliseconds
t1.repeated=true
t1.ontimer=t1_tick
t1.enabled=true

'here we read comport and print char, if any, until Z
read_port:
b=0  'not necessary; indeed read byte may = 0!
c2.read(b)
i=retfunc  'if new char read, i=1 (1 byte)
if i then print chr$(b+32);  'print lower case
if b>=90 then goto c2_close

'Another TIMER Object could be used below.
'SLEEP in a loop is a cheap, low-overhead TIMER!
sleep 0.1     'input buffer sample interval
goto read_port 

c2_close:
c2.close: print: pause
end  'end statement prevents "falling into" code below

'write through loopback connector simulates external device
t1_tick:
if rnd(3) then return  '25% chance to send char
'data sent will be A to Z
if a < 91 then
  c2.write(a): print chr$(a);: inc(a)
else
  t1.enabled=false
end if
return
