'Doctor Electron -- Net Census, http://www.angelfire.com/space/netcensus/
'This example can be used with any CGI/1.1 compliant web server.
'Sample browser url:
'http://127.0.0.1/cgi?guy=doctor+electron&site=Net+Census&game=cgi
'Compile this and put it in the CGI-BIN subdirectory of GypsyProxy.

$APPTYPE CGI
$TYPECHECK ON

Declare FUNCTION GetCGIValue(name$ AS STRING) As STRING
Declare SUB GetQueryField(index As LONG)

'dimension some generic variables
DIM q$ As STRING, r$ As STRING, s$ As STRING, n$ As STRING, v$ As STRING
Dim t$ As STRING  'temporary string used in subs and functions
DIM i As LONG, j As LONG, k As LONG  'scratch variables

'Data received with a POST is stored in DATA\Postx.dat where x=connection index.
'This data could be anything depending on how you use post.
'In this example we assume that the POST is like a QUERY_STRING.

IF ENVIRON$("REQUEST_METHOD")="POST" THEN 
  k=VAL(ENVIRON$("CONTENT_LENGTH"))
  IF k<=0 THEN PRINT "Status: 400 No Content Posted": PRINT: Goto ProgEnd
  IF k>4096 THEN k=4096  'this is to protect from excessive content length
  q$=GET$(k)  
ELSE
  q$=ENVIRON$("QUERY_STRING")  'if you expect one
END IF
IF q$="" THEN Goto GotQuery

q$=REPLACESUBSTR$(q$,"+"," ") 'replace + with space
DecodeQuery:
i=INSTR(q$,"%")
IF i=0 THEN Goto GotQuery
r$=MID$(q$,i,3)
i=HEX2DW(RIGHT$(r$,2)): s$=CHR$(i)
q$=REPLACESUBSTR$(q$,r$,s$) 'replace all %xx with char
Goto DecodeQuery

'What if some jerk put non-printable charcters in the query?
'Here we remove them, if any:
GotQuery:
i=1
NextQChar:
s$=MID$(q$,i,1)
IF (s$<" ") OR (s$>"~") THEN q$=DELETE$(q$,i,1) ELSE INC(i)
IF i<=LEN(q$) THEN Goto NextQChar

IF INSTR(ENVIRON$("SCRIPT_NAME"),"nph-")=1 THEN
'oops, this means you have to PRINT a complete web page, header & body.
PRINT ENVIRON$("SERVER_PROTOCOL")+" 200 OK"
PRINT "Server: GypsyProxy 1.2"
PRINT "Content-Type: text/html"
PRINT "Connection: Close"
PRINT
PRINT "<HTML>"
PRINT "<HEAD><TITLE>My own web page</TITLE></HEAD>"
PRINT "<BODY>This is not my page, it is yours.</BODY>"
PRINT "</HTML>"
Goto ProgEnd
END IF
'or
'give one possible "directive" to server via PRINT which is stdout.
PRINT "Content-Type: text/plain" 
'PRINT "Status: 200 OK"              'or whatever status you want
'PRINT "Location: http://[server]/[resource]" 'causes 302 Found to client
'PRINT "Location: /[resource]"       'server sends resource to client
'or any other valid http header lines here

PRINT 'Blank line to tell server what follows is content.

'There would be no content if Status: or Location: statements are used.
'We start the body by printing everything GypsyProxy put in environment.
'This may be handy to see if your form actually sends what you expect.

PRINT "decoded query:"
PRINT q$
PRINT "SERVER_SOFTWARE="+ENVIRON$("SERVER_SOFTWARE")
PRINT "SERVER_NAME="+ENVIRON$("SERVER_NAME")
PRINT "GATEWAY_INTERFACE="+ENVIRON$("GATEWAY_INTERFACE")
PRINT "SERVER_PROTOCOL="+ENVIRON$("SERVER_PROTOCOL")
PRINT "SERVER_PORT="+ENVIRON$("SERVER_PORT")
PRINT "REQUEST_METHOD="+ENVIRON$("REQUEST_METHOD")
PRINT "SCRIPT_NAME="+ENVIRON$("SCRIPT_NAME")
PRINT "PATH_INFO="+ENVIRON$("PATH_INFO")
PRINT "REMOTE_ADDR="+ENVIRON$("REMOTE_ADDR")
PRINT "CONTENT_TYPE="+ENVIRON$("CONTENT_TYPE")
PRINT "CONTENT_LENGTH="+ENVIRON$("CONTENT_LENGTH")

'Maximun index is found like this: 
IF q$<>"" THEN j=TALLY(q$,"&")+1 ELSE j=0
PRINT "Query fields = ";STR$(j)
FOR k=1 to j
GetQueryField(k)
PRINT STR$(k)+": "+n$+" is "+v$
NEXT k

v$=GetCGIValue(n$)   'let's test the GetCGIValue function
PRINT "GetCGIValue function says ";n$;" = ";v$

PRINT "Please report suspicious values to local police."
PRINT "This could have been written as a html document."
PRINT

'Use SOCKET object to get remote name from REMOTE_ADDR with .NamebyAddr Function
'Assign variables to string like this: a$=ENVIRON$("REQUEST_METHOD")
'Get values in query string like this: s$=GetCGIValue(n$) where n$ = name
'Your code here

Goto ProgEnd

'Instead of creating many string arrays, we just get values as needed.
'This is convenient because the query items can be in any order.

FUNCTION GetCGIValue(name$ AS STRING) As STRING
t$="": i=INSTR(q$,name$)
IF i=0 THEN Goto GotValue  'that name-value pair is not there
i=i+LEN(name$)
IF MID$(q$,i,1)<>"=" THEN Goto GotValue 'have name, but no "=" 
INC(i)
j=INSTR(i,q$,"&")
IF j>i THEN j=j-i ELSE j=LEN(q$)-i+1  'now j=length of value
t$=MID$(q$,i,j)
GotValue:
GetCGIValue=t$
END FUNCTION

'You probably already know the names in the query fields.
'If not, look for n$ and v$ by index.
'The GetQueryField sub returns name in n$ and value in v$

SUB GetQueryField(index As LONG)
n$="": v$=""  'globals used as generic name and value strings
IF index<1 THEN Exit Sub
t$=FIELD$(q$,"&",index)
IF t$="" THEN Exit Sub
i=INSTR(t$,"=")
IF i=0 THEN n$=t$: Exit Sub  'no "=" may be ISQUERY in CGI/1.1
n$=LEFT$(t$,i-1): v$=MID$(t$,i+1)
END SUB

ProgEnd:
END
