$APPTYPE CONSOLE
$TYPECHECK ON

$DEFINE IPPROTO_ICMP 1
$DEFINE SOCK_RAW 3

DECLARE FUNCTION sendto Lib "wsock32" (xS As LONG,_
  lpbuf As LONG, plen As LONG, flags As LONG,_
  lptoAddr As LONG, lptoLen As LONG) As LONG
DECLARE FUNCTION recvfrom Lib "wsock32" (xS As LONG,_
  lpbuf As LONG, plen As LONG, flags As LONG,_
  lpfromAddr As LONG, lpfromLen As LONG) As LONG

DECLARE SUB ICMP
DECLARE SUB ShowPacketBytes(title$ As STRING, plen As LONG)

DIM Sock as SOCKET
DIM RemoteName As STRING, ip$ As STRING, C$ As STRING, EchoString As STRING
Dim S as LONG, r As LONG, sum As LONG
DIM DestAddr(3) As LONG, ReplyAddr(4) As LONG
DIM i As LONG
DIM Ident As WORD
DIM p(575) AS BYTE    

'With the socket set as follows, the system creates the IP header
Sock.Protocol = IPPROTO_ICMP  'choose any protocol here and craft your packet 
Sock.Type = SOCK_RAW

'non-blocking modes may be used for multi-socket programs

NextTry:
ip$=null
MEMSET @p, 0, 575   'clear packet buffer
INPUT "Remote Host Name = "; RemoteName
IF RemoteName.Length THEN
  ip$ = Sock.AddrByName(RemoteName)
  PRINT "Remote IP address ";
  IF ip$.Length THEN PRINT ip$ ELSE PRINT "not found"
END IF

Ident=Ident+2
IF NOT ip$.Length THEN
  INPUT "HOST (a.b.c.d) to Ping = "; ip$
END IF
IF NOT ip$.Length THEN Goto Done
DestAddr(0)=2
DestAddr(1)=Sock.StrToAddr(ip$)  'set up structure with dest address
IF DestAddr(1)=&HFFFFFFFF THEN PRINT "Invalid address": Goto NextTry 
DestAddr(2)=0: DestAddr(3)=0

S = Sock.S  'create socket with .Protocol and .Type as above
PRINT "Socket S = "; S
IF S <=0 THEN PRINT "Failed to create socket": Goto Done

EchoString = "RawSock ICMP"
Call ICMP  'sets value j used below
ShowPacketBytes("ICMP Packet Payload:", i)

PRINT "Sending Packet at "; str$(timer)
r = sendto(S, @p, i, 0, @DestAddr, 16)
PRINT "r = "; STR$(r); " bytes sent wrapped in IP header"
IF r < 0 THEN Goto SockClose

sleep 3     'any kind of timer mechanism could be used!!

ReplyAddr(1)=0: ReplyAddr(4)=16
r = Sock.NonBlock(S)

'Now we use the send buffer for recieve buffer.  Could be different, of course.
'Watch out.  The following will retrieve icmp messages to other programs!
r = recvfrom(S, @p, 575, 0, @ReplyAddr, @ReplyAddr+16)

IF r <=0 THEN PRINT "Sorry, no reply": Goto SockClose
PRINT "r = "; STR$(r); " bytes read including IP header and data"

'ReplyAddr(1) is the long IP address value of the reply source and may be
'the same or different from your original destination -- DestAddr(1)

'A hex dump of the reply packet.  Get out RFCs 791 (IP header - 20 bytes)
'and 792 (Echo reply or error) to parse this.  That's the whole idea of
'the raw socket method, right?  You want to see the bytes.

ShowPacketBytes("Packet Reply (1st line is IP Header)", r)

SockClose:
r = Sock.Close(S)
PRINT "Closed at "; str$(timer)
Goto NextTry
Done:
END

'''''
'This creates data section of an echo request packet.
'Other icmp type & codes could be used.
SUB ICMP
p(0)=8        'icmp type; p$[1] is the code and is left at zero.
p(4)=Ident    'icmp identifier (can be anything or zero)
p(6)=Ident+1  'icmp sequence number (can be anything or zero)
MEMCPY @p+8, @EchoString, EchoString.Length 'icmp data
i = 8 + EchoString.Length       'i is packet data length excluding IP header bytes
C$=SPACE$(i): MEMCPY @C$, @p, i 'copy packet to string
sum = Sock.CheckSum(C$)     'calculates the checksum as sum for j bytes
MEMCPY @p+2, @sum, 2       'stores checksum in data buffer
END SUB

''''''
SUB ShowPacketBytes(title$ As STRING, plen As LONG)
PRINT title$
C$.Clear
FOR i = 1 to plen
C$.WriteStr(RIGHT$(HEX$(p(i-1)),2)+space, 3)
IF i MOD 20 = 0 THEN PRINT C$: C$.Clear
NEXT i: PRINT C$
END SUB
