$APPTYPE CONSOLE: $TYPECHECK ON

'define your UDT
TYPE INV_RECORD
  PartNum As LONG
  PartName As STRING*48
  InStock As LONG
  Supplier As LONG
  Supplier2 As LONG
END INV_RECORD

DIM ThisRec as INV_RECORD  'working UDT instance
DIM InvArray(199) as INV_RECORD  '200 UDT's
DIM i As LONG, UDT_changed As LONG, RecLen As LONG
RecLen = SIZEOF(INV_RECORD)

Declare SUB UDTarray (Next as LONG)
'note we DIM ThisUDT in the DECLARE:
Declare SUB PrtPartName (ThisUDT As INV_RECORD)

'you might load your InvArray from a file (see ArrayIO.bas)
'let's work with record 186
'notice subscript used only to get/put a block of UDT data

UDTarray(186)  'to read 0-based record i

'your code to process UDT record 186
ThisRec.PartName = "HotBasic UDT arrays -- deluxe version"
'If you change anything in ThisRec and want to save it:
INC(UDT_changed)
PRINT "Rec 186 "; ThisRec.PartName

'As test we get another record:
UDTarray(146)  'to read 0-based record i
PRINT "Rec 146 "; ThisRec.PartName

'Back to record 186 to see if we have the data right:
UDTarray(186)
PRINT "Rec 186 "; ThisRec.PartName

'This is the deluxe version, since you do not need the
'subscript to read/write ThisRec values.  Very efficient!

'Let's try copying and using an array element in a SUB
PrtPartName(InvArray(186))

'Let's try copying from one UDT array to another:
DIM Inv2(9) as INV_RECORD
Inv2(5) = InvArray(186)  'array-to-array UDT copy
PrtPartName(Inv2(5))     'print to verify copy

PAUSE
END

'Optional SUB to manage UDT array reads and writes:
SUB UDTarray  '(Next as LONG)
DIM Last as LONG  
IF UDT_changed THEN InvArray(Last)=ThisRec
ThisRec=InvArray(Next)
Last = Next : UDT_changed = 0
END SUB

'Work with UDT array element in a SUB:
SUB PrtPartName  '(ThisUDT As INV_RECORD)
PRINT ThisUDT.PartName; " # Printed From SUB!"
END SUB
