'breakpt.bas shows how to insert alternate code
'in the code (.text) section of an .exe processed
'with code_rw.exe to make that section writable.

$APPTYPE CONSOLE: $TYPECHECK ON

defint i
'Here 6 is a minimum value; enough to insert
'a call opcode for a debugger to call its own routine
'and in this demo, to replace INC(i) binary.
'That is, the use of nop here is just to test
'if we can insert alternate binary code.
defstr nop=string$(6,chr$(&H90))  'nop opcodes
defstr bin=space$(6)  'holds orginal binary

declare sub xyz
defint Axyz=codeptr(xyz)

PRINT "Let's increment i by calling SUB xyz"
xyz
PRINT "i = "; i  'should be 1

PRINT "Next we copy nop opcodes to overwrite INC(i)"
memcpy @bin,Axyz,6  'save binary for INC(i)
'print bin
memcpy Axyz,@nop,6  'put nop opcodes there
xyz
PRINT "i = "; i  'should still be 1

PRINT "Now we restore the INC(i) binary"
memcpy Axyz,@bin,6
xyz
PRINT "i = "; i  'should be 2

sub xyz
inc(i)
end sub

PAUSE
END
