$APPTYPE CONSOLE: $TYPECHECK ON
DIM k$ As STRING, s$ As STRING, Time As REAL10
DEFLNG i,sqlret,comret
DEFSTR db$,com$,value$,err$

k$="HotBasic SQLite Expedition"
App.Title=k$: COLOR 15: PRINT k$: COLOR 7

DIM sql As SQLite

'set up a command script in com$ using it as a LIST
'com$ examples from www.sqlite.org

com$.AddItems "CREATE TABLE table1(one varchar(10), two smallint);"
com$.AddItems "insert into table1 values('hello!', 10);"
com$.AddItems "insert into table1 values('goodbye', 20);"
com$.AddItems "select * from table1;"
com$.AddItems "select two from table1;"
com$.AddItems "CREATE TABLE table2 (f1 varchar(30) primary key, f2 text, f3 real);"
com$.AddItems "insert into table2 values('HotBasic', 'HotBabe', 1.0);"
com$.AddItems "select * from table2;"

'crashes if sqlite_master query lacks type='table'
com$.AddItems "select * from sqlite_master where type='table';"

db$ = "mydata.sql"
kill db$  'the kill is just to have a clean slate for this test

'in CGI or generally, other programs may have locked db$
'so we try to open it for a time period

Time=TIMER  
TryAgain:
sqlret = sql.Open(db$)

IF sqlret THEN
  PRINT ".Open ";db$;" with pointer/handle = ";sqlret
  For i = 0 to com$.ItemCount-1
  s$=com$.Item(i)
  COLOR 11: PRINT s$: COLOR 7
  comret = sql.Command(s$)
' PRINT ".Command returned code = ";comret
  IF comret=0 THEN
    NextRow:
    sqlret = sql.Row
'    PRINT ".Row returned code = ";sqlret
    IF sqlret = 100 THEN
      value$ = sql.RowValue
      PRINT ".RowValue    = ";value$
      Goto NextRow
    END IF
  ELSE
    GOSUB sqlstatus
  END IF
  IF sql.ColumnCount THEN GOSUB sqlstatus
  sqlret = sql.Finalize  'always call before next .Command call
  NEXT i
  sql.Close
ELSE
  IF TIMER-Time < 5.0 THEN SLEEP 0.1: Goto TryAgain
END IF
pause
END

sqlstatus:
'PRINT "SQL OBJECT STATUS:"
err$ = sql.Error
PRINT ".Error       = ";err$
IF err$.Length THEN sql.FreeMemory
PRINT ".ColumnCount = ";sql.ColumnCount
PRINT ".ColumnNames = ";sql.ColumnNames
RETURN
