$APPTYPE CONSOLE: $TYPECHECK ON
'$RESOURCE Hot_icon AS "hotbasic.ico"
$SYMBOLTABLE ON
DIM i As LONG, j As LONG, k As LONG, n As LONG, k$ As STRING
DEFREAL10 x,y,z

COLOR 15
PRINT "HotBasic(tm) Operator Precedence and Numeric Expression Test 1.1"
COLOR 7

COLOR 11: PRINT "Operator Precedence": COLOR 7
i=2+3*7
PRINT "2+3*7 = "; STR$(i);
IF i = 23 THEN PRINT " correct" ELSE PRINT " WRONG!"
j=2*3+7
PRINT "2*3+7 = "; STR$(j);
IF j = 13 THEN PRINT " correct" ELSE PRINT " WRONG!"
j=2 OR 3*7
PRINT "2 OR 3*7 = "; STR$(j);
IF j = 23 THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11: PRINT "Operator Precedence Over-ride": COLOR 7
i=(2+3)^2
PRINT "(2+3)^2 = "; STR$(i);
IF i = 25 THEN PRINT " correct" ELSE PRINT " WRONG!"
i=2^(1+2)
PRINT "2^(1+2) = "; STR$(i);
IF i = 8 THEN PRINT " correct" ELSE PRINT " WRONG!"
j=5*(3+1)
PRINT "5*(3+1) = "; STR$(j);
IF j = 20 THEN PRINT " correct" ELSE PRINT " WRONG!"

x=0.5
COLOR 11: PRINT "More complex; x = 0.5": COLOR 7

z=atan(x/sqr(1-x^2))
y=asin(x)
PRINT "asin(x) = atan(x/sqr(1-x^2)) = "; STR$(z);
IF abs(z-y)<0.000000000000001 THEN PRINT " correct" ELSE PRINT " WRONG!"

z=atan(sqr(1-x^2)/x)
PRINT "acos(x) = atan(sqr(1-x^2)/x) = "; STR$(z);
IF z = acos(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

z=(exp(x)-exp(-(x)))/2
PRINT "hsin(x) = (exp(x)-exp(-(x)))/2 = "; STR$(z);
IF z = hsin(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

z=(exp(x)+exp(-(x)))/2
PRINT "hcos(x) = (exp(x)+exp(-(x)))/2 = "; STR$(z);
IF z = hcos(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

'this monster expression is used here for testing:
z=(exp(x)-exp(-(x)))/(exp(x)+exp(-(x)))

'obviously, it is much more efficient to do this:
'y=exp(x): z=exp(-(x))   'note "-(x)" = "neg(x)"
'z=(y-z)/(y+z)

PRINT "htan(x) = (exp(x)-exp(-(x)))/(exp(x)+exp(-(x))) = "; STR$(z);
IF z = htan(x) THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11: PRINT "Unnecessary () in conditional expression": COLOR 7
if (1=3) or (2=2) then print "correct"
if ("a"="b") or ("c"="c") then print "correct"

COLOR 11: PRINT "Precedence over-ride in function argument": COLOR 7
i = int(100.00*(2.75 - 2.00))
PRINT "int(100.00*(2.75 - 2.00)) = "; STR$(i);
IF i = 75 THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11: PRINT "Leading precedence over-ride in function argument": COLOR 7
i = int((2.75 - 2.00) * 100.00)
PRINT "int((2.75 - 2.00) * 100.00) = "; STR$(i);
IF i = 75 THEN PRINT " correct" ELSE PRINT " WRONG!"
i = FIX(((2000.0-1000.0)*(8.0/100) + (200.0/100))*100)
PRINT "FIX(((2000.0-1000.0)*(8.0/100) + (200.0/100))*100) = "; STR$(i);
IF i = 8200 THEN PRINT " correct" ELSE PRINT " WRONG!"
pause

COLOR 11
PRINT "String function(numeric_arg) followed by +"
COLOR 7
k$="##"
k$=k$+CHR$(65)+k$
PRINT "k$+CHR$(65)+k$ = "; k$;
IF k$="##A##" THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11
PRINT "String function(string_arg) followed by +";
COLOR 7
k$="-reversed"
k$=reverse$(k$) + "not reversed"
IF k$="desrever-not reversed" THEN PRINT " correct"; ELSE PRINT " WRONG!";

k$=TRIM$("hello   ")+" world"
IF k$="hello world" THEN PRINT " correct" ELSE PRINT " WRONG!"

k$="9876543210"
i = VAL(Mid$(k$, 1, 2)) + VAL(Mid$(k$, 4, 2)) * 10 _
  + VAL(Mid$(k$,7, 4)) * 100
j=98+650+321000
COLOR 11
PRINT "Val(string function) in numeric expression";
COLOR 7
IF i=j THEN PRINT " correct" ELSE PRINT " WRONG!"

k$ = STR$((1800 / 100) MOD 100)
COLOR 11
PRINT "Leading Precedence over-ride in string function argument";
COLOR 7
IF k$="18" THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11
PRINT "INSTR as argument in string function";
COLOR 7
k$= "funny thing"
k$=left$(k$, instr(k$, "thing") - 2)
IF k$="funny" THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11
PRINT "Don's year expression:"
COLOR 7
DEFINT N
N=10^3
i=2*N/4+(N-100)/(N/5+20)+N+N-N/2-6
PRINT "2*N/4+(N-100)/(N/5+20)+N+N-N/2-6 = "; STR$(i);
IF i=1998 THEN PRINT " correct" ELSE PRINT " WRONG!"
COLOR 11
PRINT "With unneeded ():"
COLOR 7
i=2*N/4+(N-100)/(N/5+20)+N+(N-(N/2))-6
PRINT "2*N/4+(N-100)/(N/5+20)+N+(N-(N/2))-6 = "; STR$(i);
IF i=1998 THEN PRINT " correct" ELSE PRINT " WRONG!"

COLOR 11
PRINT "Nested Precedence over-ride:"
COLOR 7
i = 2 * ((4 AND 2) + 6)
PRINT "2 * ((4 AND 2) + 6) = "; STR$(i);
IF i=12 THEN PRINT " correct" ELSE PRINT " WRONG!"

pause
END
